Imports System.Drawing

Module Module1
    ' La classe de base abstraite Forme
    MustInherit Class Forme
        ' Proprits PointDepart
        Private mPointDepart As Point
        Public Property PointDepart() As Point
            Set
                mPointDepart = Value
            End Set
            Get
                Return mPointDepart
            End Get
        End Property
        
        ' Mthode que toutes les classes drives doivent implmenter
        Public MustOverride Sub Dessiner()
    End Class
    
    ' Une classe drive Ligne
    Class Ligne : Inherits Forme
        ' Proprit PointArrivee
        Private mPointArrivee As Point
        Public Property PointArrivee() As Point
            Set
                mPointArrivee = value
            End Set
            Get
                Return mPointArrivee
            End Get
        End Property
        
        ' Implmentation de la mthode Dessiner
        Public Overrides Sub Dessiner()
            ' Dessine une ligne
            Console.WriteLine("Dessine une ligne de {0},{1}  {2},{3}", _
                    PointDepart.X, PointDepart.Y, PointArrivee.X, PointArrivee.Y)
        End Sub
    End Class
    
    ' Une classe drive Rectangle
    Class Rectangle : Inherits Forme
        ' Proprit Dimensions
        Private mDimensions As Size
        Public Overridable Property Dimensions() As Size
            Set
                mDimensions = value
            End Set
            Get
                Return mDimensions
            End Get
        End Property
        
        ' Implmentation de la mthode Dessiner
        Public Overrides Sub Dessiner()
            ' Dessine un rectangle
            Console.WriteLine("Dessine un rectangle  partir de {0},{1}, dimensions {2},{3}", _
                    PointDepart.X, PointDepart.Y, Dimensions.Width, Dimensions.Height)
        End Sub
    End Class
    
    ' Une classe driv de Rectangle, Carre
    Class Carre : Inherits Rectangle
        ' Redfinition de la proprit Dimensions
        Public Overrides Property Dimensions() As Size
            Set
                ' Met la largeur  la hauteur
                CType(Value, Size).Height = CType(Value, Size).Width
                MyBase.Dimensions = Value
            End Set
            Get
                Return MyBase.Dimensions
            End Get
        End Property
        
        ' Implmentation de la mthode Dessiner
        Public Overrides Sub Dessiner()
            ' Dessine un carr
            Console.WriteLine("Dessine un carr  partir de {0},{1}, ct {2}", _
                    PointDepart.X, PointDepart.Y, Dimensions.Width)
        End Sub
    End Class
    
    Sub Main()
        ' Cre quelques figures
        Dim Ligne As New Ligne()
        Dim Rectangle As New Rectangle()
        Dim Carre As New Carre()
        
        ' Ligne
        Ligne.PointDepart = New Point(10, 20)
        Ligne.PointArrivee = New Point(100, 110)
        
        ' Rectangle
        Rectangle.PointDepart = New Point(10, 20)
        Rectangle.Dimensions = New size(100, 110)
        
        ' Carr
        Carre.PointDepart = New Point(10, 20)
        Carre.Dimensions = New size(100, 100)
        
        ' Met toutes les figures dans un tableau
        Dim Figures(3) As Forme
        Figures(0) = Ligne
        Figures(1) = Rectangle
        Figures(2) = Carre
        
        ' Puis explore
        Dim f As Forme
        For Each f In Figures
            f.Dessiner()
        Next
        
        ' Attend une touche
        Console.Read()
    End Sub
    
End Module
