Imports System.Drawing
Imports System.WinForms
Imports System.Math
Imports Microsoft.VisualBasic.Compatibility.VB6
Imports System.Threading
Imports System.ComponentModel


Public Class Dessin
    Inherits System.WinForms.Form
    
    ' Nombre de lignes dessines
    Private Const NB As Integer = 30
    ' Tableau des lignes
    Private x1(NB), y1(NB), x2(NB), y2(NB) As Single
    ' Dplacement
    Private dx1, dy1, dx2, dy2 As Single
    ' Crayons
    Private theWhitePen As New Pen(Color.white, 1)
    Private theBlackPen As New Pen(Color.black, 1)
    
    ' Ligne courante
    Private n As Integer
    ' Indique premier dessin
    Private mPrem As Boolean
    Dim r As New Random()
    
    ' Thread
    Dim thr As Threading.Thread
    Dim fRun As Boolean
    Dim SleepTime As Integer = 1
    
    Public Sub New()
        MyBase.New

        Dessin = Me

        'This call is required by the Win Form Designer.
        InitializeComponent()

        ' Dplacements initiaux
        dx1 = Delta()
        dy1 = Delta()
        dx2 = Delta()
        dy2 = Delta()
        ' Points initiaux
        x1(0) = CSng(Int((Me.Size.Width + 1) * rnd))
        y1(0) = CSng(Int((Me.Size.Height + 1) * rnd))
        x2(0) = CSng(Int((Me.Size.Width + 1) * rnd))
        y2(0) = CSng(Int((Me.Size.Height + 1) * rnd))
        
        ' Menu contextuel
        mnuV2.Checked = True
        
        ' Cre le thread
        thr = New Threading.Thread(AddressOf ThreadDessin)
        frun = True
        ' et le dmarre
        thr.Start()
    End Sub
    
    'Form overrides dispose to clean up the component list.
    Public Overrides Sub Dispose()
        MyBase.Dispose()
        components.Dispose()
    End Sub
    
#Region " Windows Form Designer generated code "
    
    'Required by the Windows Form Designer
    Private components As System.ComponentModel.Container
    Private WithEvents mnuV3 As System.WinForms.MenuItem
    Private WithEvents mnuV2 As System.WinForms.MenuItem
    Private WithEvents mnuV1 As System.WinForms.MenuItem
    Private WithEvents mnuV0 As System.WinForms.MenuItem
    Private WithEvents ContextMenu1 As System.WinForms.ContextMenu
    
    
    
    Dim WithEvents Dessin As System.WinForms.Form
    
    'NOTE: The following procedure is required by the Windows Form Designer
    'It can be modified using the Windows Form Designer.  
    'Do not modify it using the code editor.
    Private Sub InitializeComponent()
        Me.components = New System.ComponentModel.Container()
        Me.mnuV1 = New System.WinForms.MenuItem()
        Me.ContextMenu1 = New System.WinForms.ContextMenu()
        Me.mnuV2 = New System.WinForms.MenuItem()
        Me.mnuV3 = New System.WinForms.MenuItem()
        Me.mnuV0 = New System.WinForms.MenuItem()
        
        '@design Me.TrayHeight = 90
        '@design Me.TrayLargeIcon = False
        '@design Me.TrayAutoArrange = True
        mnuV1.Text = "Plus vite"
        mnuV1.RadioCheck = True
        mnuV1.Index = 1
        
        '@design ContextMenu1.SetLocation(New System.Drawing.Point(7, 7))
        Dim a__1(4) As System.WinForms.MenuItem
        a__1(0) = mnuV0
        a__1(1) = mnuV1
        a__1(2) = mnuV2
        a__1(3) = mnuV3
        ContextMenu1.MenuItems.All = a__1
        
        mnuV2.Text = "Encore plus vite"
        mnuV2.RadioCheck = True
        mnuV2.Index = 2
        
        mnuV3.Text = "Trs vite"
        mnuV3.RadioCheck = True
        mnuV3.Index = 3
        
        mnuV0.Text = "Lent"
        mnuV0.RadioCheck = True
        mnuV0.Index = 0
        Me.Text = "Dessin"
        Me.AutoScaleBaseSize = New System.Drawing.Size(5, 13)
        Me.ContextMenu = ContextMenu1
        Me.ClientSize = New System.Drawing.Size(292, 279)
        
    End Sub
    
#End Region
    
    Private Sub ThreadDessin()
        Do While fRun
            Dessine()
            Thread.Sleep(SleepTime)
        Loop
    End Sub
    
    Public Sub Dessine()
        ' Nouvelle position
        Dim n1 As Integer
        n1 = (n + 1) Mod NB
        ' Efface l'ancienne ligne
        Dim g As Graphics = Me.CreateGraphics
        g.CompositingMode = Drawing.Drawing2D.CompositingMode.SourceOver
        If Not mPrem Then g.drawline(theBlackPen, x1(n1), y1(n1), x2(n1), y2(n1))
        mPrem = False
        
        ' Nouvelles coordonnes
        x1(n1) = x1(n) + dx1
        y1(n1) = y1(n) + dy1
        x2(n1) = x2(n) + dx2
        y2(n1) = y2(n) + dy2
        ' Sort du cadre ?
        With Me
            If x1(n1) < 0 Then x1(n1) = 0 : dx1 = -Sign(dx1) * Abs(Delta())
            If x1(n1) > .Size.Width Then x1(n1) = .Size.Width : dx1 = -Sign(dx1) * Abs(Delta())
            If y1(n1) < 0 Then y1(n1) = 0 : dy1 = -Sign(dy1) * Abs(Delta())
            If y1(n1) > .Size.Height Then y1(n1) = .Size.Height : dy1 = -Sign(dy1) * Abs(Delta())
            If x2(n1) < 0 Then x2(n1) = 0 : dx2 = -Sign(dx2) * Abs(Delta())
            If x2(n1) > .Size.Width Then x2(n1) = .Size.Width : dx2 = -Sign(dx2) * Abs(Delta())
            If y2(n1) < 0 Then y2(n1) = 0 : dy2 = -Sign(dy2) * Abs(Delta())
            If y2(n1) > .Size.Height Then y2(n1) = .Size.Height : dy2 = -Sign(dy2) * Abs(Delta())
        End With
        ' Nouvelle ligne
        g.DrawLine(theWhitePen, x1(n1), y1(n1), x2(n1), y2(n1))
        ' Nouvel indice courant
        n = n1
    End Sub
    
    ' ---- Calcule un delta (entre -5 et +5 mais pas 0)
    Private Function Delta() As Integer
        Delta = CInt(5 * rnd + 1) * (2 * Int(CInt(2 * rnd)) - 1)
    End Function
    
    Protected Overrides Sub OnPaint(ByVal e As System.WinForms.PaintEventArgs)
        e.Graphics().FillRectangle(New SolidBrush(Color.Black), ClientRectangle)
    End Sub
    
    Protected Overrides Sub OnClosed(ByVal e As System.EventArgs)
        fRun = False
    End Sub
    
    Public Sub Dessin_MouseDown(ByVal sender As Object, ByVal e As System.WinForms.MouseEventArgs) Handles Dessin.MouseDown
        thr.Suspend()
    End Sub
    
    Public Sub Dessin_MouseUp(ByVal sender As Object, ByVal e As System.WinForms.MouseEventArgs) Handles Dessin.MouseUp
        On Error Resume Next
        thr.Resume()
    End Sub
    
    Public Sub mnuV0_Click(ByVal sender As Object, ByVal e As System.EventArgs)
        SleepTime = 50
        mnuV0.Checked = True
        mnuV1.Checked = False
        mnuV2.Checked = False
        mnuV3.Checked = False
    End Sub
    
    Public Sub mnuV1_Click(ByVal sender As Object, ByVal e As System.EventArgs)
        SleepTime = 10
        mnuV0.Checked = False
        mnuV1.Checked = True
        mnuV2.Checked = False
        mnuV3.Checked = False
    End Sub
    
    Public Sub mnuV2_Click(ByVal sender As Object, ByVal e As System.EventArgs)
        SleepTime = 1
        mnuV0.Checked = False
        mnuV1.Checked = False
        mnuV2.Checked = True
        mnuV3.Checked = False
    End Sub
    
    Public Sub mnuV3_Click(ByVal sender As Object, ByVal e As System.EventArgs)
        SleepTime = 0
        mnuV0.Checked = False
        mnuV1.Checked = False
        mnuV2.Checked = False
        mnuV3.Checked = True
    End Sub
End Class
