Imports System.ComponentModel
Imports System.Drawing
Imports System.Drawing.Drawing2D
Imports System.WinForms


Public Class Form1
    Inherits System.WinForms.Form
    
    ' Crayon
    Dim CrayonPoints As New Pen(Color.Gray)
    
    Public Sub New()
        MyBase.New

        Form1 = Me

        'This call is required by the Win Form Designer.
        InitializeComponent

        'TODO: Add any initialization after the InitializeComponent() call
        ' Gestion des vnements
        AddHandler optRouge.click, AddressOf optCouleur
        AddHandler optVert.click, AddressOf optCouleur
        AddHandler optBleu.click, AddressOf optCouleur
        
        optRouge.Checked = True
        optPlein.Checked = True
        optRectangle.Checked = True
    End Sub

    'Form overrides dispose to clean up the component list.
    Overrides Public Sub Dispose()
        MyBase.Dispose
        components.Dispose
    End Sub 

#Region " Windows Form Designer generated code "

    'Required by the Windows Form Designer
    Private components As System.ComponentModel.Container
    Private WithEvents optRectangle As System.WinForms.RadioButton
    
    
    
    Private WithEvents optEllipse As System.WinForms.RadioButton
        Private WithEvents Panel1 As System.WinForms.Panel
    
    
    
    
    Private WithEvents iml As System.WinForms.ImageList
    Private WithEvents optAlpha As System.WinForms.RadioButton
    Private WithEvents optBleu As System.WinForms.RadioButton
    
    Private WithEvents optRouge As System.WinForms.RadioButton
    
    
    Private WithEvents optVert As System.WinForms.RadioButton
    Private WithEvents pnlCouleur As System.WinForms.Panel
    Private WithEvents optGradient As System.WinForms.RadioButton
    
    Private WithEvents optHachure As System.WinForms.RadioButton
    Private WithEvents optTexture As System.WinForms.RadioButton
    Private WithEvents optPlein As System.WinForms.RadioButton
    Private WithEvents pnlPinceau As System.WinForms.Panel
    Private WithEvents PictureBox1 As System.WinForms.PictureBox
    
    Dim WithEvents Form1 As System.WinForms.Form

    'NOTE: The following procedure is required by the Windows Form Designer
    'It can be modified using the Windows Form Designer.  
    'Do not modify it using the code editor.
    Private Sub InitializeComponent()
        Dim resources As System.Resources.ResourceManager = New System.Resources.ResourceManager(GetType(Form1))
        
        Me.components = New System.ComponentModel.Container()
        Me.optAlpha = New System.WinForms.RadioButton()
        Me.optPlein = New System.WinForms.RadioButton()
        Me.optBleu = New System.WinForms.RadioButton()
        Me.optVert = New System.WinForms.RadioButton()
        Me.optRouge = New System.WinForms.RadioButton()
        Me.optGradient = New System.WinForms.RadioButton()
        Me.optTexture = New System.WinForms.RadioButton()
        Me.pnlPinceau = New System.WinForms.Panel()
        Me.optHachure = New System.WinForms.RadioButton()
        Me.optRectangle = New System.WinForms.RadioButton()
        Me.pnlCouleur = New System.WinForms.Panel()
        Me.iml = New System.WinForms.ImageList()
        Me.Panel1 = New System.WinForms.Panel()
        Me.optEllipse = New System.WinForms.RadioButton()
        Me.PictureBox1 = New System.WinForms.PictureBox()
        
        '@design Me.TrayHeight = 90
        '@design Me.TrayLargeIcon = False
        '@design Me.TrayAutoArrange = True
        optAlpha.Location = New System.Drawing.Point(8, 40)
        optAlpha.Text = "Alpha"
        optAlpha.Size = New System.Drawing.Size(72, 24)
        optAlpha.Appearance = System.WinForms.Appearance.Button
        optAlpha.TabIndex = 1
        optAlpha.BackColor = System.Drawing.SystemColors.Control
        optAlpha.TextAlign = System.Drawing.ContentAlignment.MiddleCenter
        
        optPlein.Location = New System.Drawing.Point(8, 8)
        optPlein.Text = "Plein"
        optPlein.Size = New System.Drawing.Size(72, 24)
        optPlein.Appearance = System.WinForms.Appearance.Button
        optPlein.TabIndex = 0
        optPlein.BackColor = System.Drawing.SystemColors.Control
        optPlein.TextAlign = System.Drawing.ContentAlignment.MiddleCenter
        
        optBleu.Location = New System.Drawing.Point(8, 72)
        optBleu.Text = "Bleu"
        optBleu.Size = New System.Drawing.Size(72, 24)
        optBleu.ForeColor = System.Drawing.Color.White
        optBleu.Appearance = System.WinForms.Appearance.Button
        optBleu.TabIndex = 7
        optBleu.BackColor = System.Drawing.Color.Blue
        optBleu.TextAlign = System.Drawing.ContentAlignment.MiddleCenter
        
        optVert.Location = New System.Drawing.Point(8, 40)
        optVert.Text = "Vert"
        optVert.Size = New System.Drawing.Size(72, 24)
        optVert.ForeColor = System.Drawing.Color.White
        optVert.Appearance = System.WinForms.Appearance.Button
        optVert.TabIndex = 6
        optVert.BackColor = System.Drawing.Color.Green
        optVert.TextAlign = System.Drawing.ContentAlignment.MiddleCenter
        
        optRouge.Location = New System.Drawing.Point(8, 8)
        optRouge.Text = "Rouge"
        optRouge.Size = New System.Drawing.Size(72, 24)
        optRouge.ForeColor = System.Drawing.Color.White
        optRouge.Appearance = System.WinForms.Appearance.Button
        optRouge.TabIndex = 5
        optRouge.BackColor = System.Drawing.Color.Red
        optRouge.TextAlign = System.Drawing.ContentAlignment.MiddleCenter
        
        optGradient.Location = New System.Drawing.Point(8, 136)
        optGradient.Text = "Gradient"
        optGradient.Size = New System.Drawing.Size(72, 24)
        optGradient.Appearance = System.WinForms.Appearance.Button
        optGradient.TabIndex = 4
        optGradient.BackColor = System.Drawing.SystemColors.Control
        optGradient.TextAlign = System.Drawing.ContentAlignment.MiddleCenter
        
        optTexture.Location = New System.Drawing.Point(8, 72)
        optTexture.Text = "Texture"
        optTexture.Size = New System.Drawing.Size(72, 24)
        optTexture.Appearance = System.WinForms.Appearance.Button
        optTexture.TabIndex = 2
        optTexture.BackColor = System.Drawing.SystemColors.Control
        optTexture.TextAlign = System.Drawing.ContentAlignment.MiddleCenter
        
        pnlPinceau.BackColor = System.Drawing.SystemColors.Control
        pnlPinceau.Size = New System.Drawing.Size(88, 168)
        pnlPinceau.TabIndex = 1
        
        optHachure.Location = New System.Drawing.Point(8, 104)
        optHachure.Text = "Hachur"
        optHachure.Size = New System.Drawing.Size(72, 24)
        optHachure.Appearance = System.WinForms.Appearance.Button
        optHachure.TabIndex = 3
        optHachure.BackColor = System.Drawing.SystemColors.Control
        optHachure.TextAlign = System.Drawing.ContentAlignment.MiddleCenter
        
        optRectangle.Location = New System.Drawing.Point(8, 8)
        optRectangle.Text = "Rectangle"
        optRectangle.Size = New System.Drawing.Size(72, 24)
        optRectangle.Appearance = System.WinForms.Appearance.Button
        optRectangle.TabIndex = 4
        optRectangle.BackColor = System.Drawing.SystemColors.Control
        optRectangle.TextAlign = System.Drawing.ContentAlignment.MiddleCenter
        
        pnlCouleur.BackColor = System.Drawing.SystemColors.Control
        pnlCouleur.Location = New System.Drawing.Point(0, 168)
        pnlCouleur.Size = New System.Drawing.Size(88, 104)
        pnlCouleur.TabIndex = 3
        
        '@design iml.SetLocation(New System.Drawing.Point(7, 7))
        iml.ImageSize = New System.Drawing.Size(160, 160)
        iml.ImageStream = CType(resources.GetObject("iml.ImageStream"), System.WinForms.ImageListStreamer)
        iml.ColorDepth = System.WinForms.ColorDepth.Depth8Bit
        iml.TransparentColor = System.Drawing.Color.Transparent
        
        Panel1.BackColor = System.Drawing.SystemColors.Control
        Panel1.Location = New System.Drawing.Point(0, 272)
        Panel1.Size = New System.Drawing.Size(88, 72)
        Panel1.TabIndex = 4
        
        optEllipse.Location = New System.Drawing.Point(8, 40)
        optEllipse.Text = "Ellipse"
        optEllipse.Size = New System.Drawing.Size(72, 24)
        optEllipse.Appearance = System.WinForms.Appearance.Button
        optEllipse.TabIndex = 0
        optEllipse.BackColor = System.Drawing.SystemColors.Control
        optEllipse.TextAlign = System.Drawing.ContentAlignment.MiddleCenter
        
        PictureBox1.BackColor = System.Drawing.SystemColors.Control
        PictureBox1.Dock = System.WinForms.DockStyle.Left
        PictureBox1.Size = New System.Drawing.Size(88, 357)
        PictureBox1.TabIndex = 2
        PictureBox1.TabStop = False
        Me.Text = "Surfaces"
        Me.AutoScaleBaseSize = New System.Drawing.Size(5, 13)
        Me.BackColor = System.Drawing.Color.White
        Me.ClientSize = New System.Drawing.Size(440, 357)
        
        pnlCouleur.Controls.Add(optBleu)
        pnlCouleur.Controls.Add(optVert)
        pnlCouleur.Controls.Add(optRouge)
        pnlPinceau.Controls.Add(optAlpha)
        pnlPinceau.Controls.Add(optGradient)
        pnlPinceau.Controls.Add(optHachure)
        pnlPinceau.Controls.Add(optTexture)
        pnlPinceau.Controls.Add(optPlein)
        Panel1.Controls.Add(optEllipse)
        Panel1.Controls.Add(optRectangle)
        Me.Controls.Add(Panel1)
        Me.Controls.Add(pnlCouleur)
        Me.Controls.Add(pnlPinceau)
        Me.Controls.Add(PictureBox1)
    End Sub
    
#End Region
    
    Dim Couleur As Color
    
    Protected Sub optCouleur(ByVal sender As Object, ByVal e As System.EventArgs)
        Couleur = CType(sender, RadioButton).BackColor
    End Sub
    
    Dim Points(2) As Point
    Dim i As Integer
    
    Public Sub Form1_MouseDown(ByVal sender As Object, ByVal e As System.WinForms.MouseEventArgs) Handles Form1.MouseDown
        Dim g As Graphics = Graphics.FromHWND(Me.handle)
        If e.Button = MouseButtons.Left Then
            ' Affiche le point
            g.DrawLine(CrayonPoints, e.X - 5, e.Y - 5, e.X + 5, e.Y + 5)
            g.DrawLine(CrayonPoints, e.X - 5, e.Y + 5, e.X + 5, e.Y - 5)
            
            ' Ajoute aux points
            Points(i) = New Point(e.X, e.Y)
            i += 1
            
            ' 2 points ?
            If i = 2 Then
                Dessine(g)
                i = 0
            End If
        End If
    End Sub
    
    Private Sub Dessine(ByVal g As Graphics)
        Dim Pinceau As Brush
        
        ' Dfinit le pinceau
        If optPlein.Checked Then
            Pinceau = New SolidBrush(Couleur)
            
        ElseIf optAlpha.Checked Then
            Pinceau = New SolidBrush(color.FromARGB(128, Couleur))
            
        ElseIf optTexture.Checked Then
            Pinceau = New TextureBrush(iml.Images(0))
            
        ElseIf optHachure.Checked Then
            Pinceau = New HatchBrush(HatchStyle.ForwardDiagonal, Couleur, Color.Transparent)
            
        ElseIf optGradient.Checked Then
            Pinceau = New LinearGradientBrush(Points(0), Points(1), Couleur, Color.Yellow)
        End If
        
        ' Affiche le polygone
        Dim rc As New Rectangle(Points(0), New Size(Points(1).X - Points(0).X, Points(1).Y - Points(0).Y))
        If optRectangle.Checked Then
            g.FillRectangle(Pinceau, rc)
        Else
            g.FillEllipse(Pinceau, rc)
        End If
        
    End Sub
End Class
