import java.awt.*;
import java.awt.event.*;
import com.sun.java.swing.*;

public class Chaines3 {
	public static void main( String[] args ) {
		final Dimension screenSize = 
								Toolkit.getDefaultToolkit().getScreenSize();
		final int largeurEcran = screenSize.width;
		final int hauteurEcran = screenSize.height + 2;
		int l = 300;
		int h = 100;
		String s = "Au fond de son me, cependant, elle attendait un vnement. Comme les matelots en dtresse, elle promenait sur la solitude de sa vie des yeux dsesprs, cherchant au loin quelque voile blanche dans les brumes de l'horizon.";

		JFrame frame = new JFrame();
		frame.addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				System.exit(0);
			}});
		frame.getContentPane().add(new TextPanel(0, 0, l, h, s));
		frame.setBounds ((largeurEcran - l) / 2, (hauteurEcran - h) / 2, l, h);
		frame.setResizable(false);
		frame.setVisible(true);
	}
}

class TextPanel extends Panel {
	Font labelFont = new Font("Helvetica", Font.BOLD, 11);	
	FontMetrics fontMetrics = getFontMetrics(labelFont);
	Color
		fColor = new Color(223, 223, 223),
		fColorC = new Color(255, 255, 255),
		fColorF = new Color(63, 63, 63),
		bColorF = new Color(32, 64, 96),
		bColorC = new Color(156, 171, 196),
		bColor = new Color(128, 144, 175);
	String texte;	
	int
		largeur = 0,		// Largeur du composant
		hauteur = 0,		// Hauteur du composant
		xt = 8,		// Coordonne horizontale du texte (marge gauche)
		yt = 13,	// Coordonne verticale du texte (premire ligne)
		ht = 13,	// Interligne
		lMax = 0;	// Longueur maximale d'une ligne (en tenant 
						// compte des marges)
	String[] mots = new String[300];
	String[] lignes = new String[6];
	int[] llignes = new int[6];
	int numLignes;	// Nombre de lignes
	int i;
	int space;

	TextPanel (int x, int y, int l, int h, String s) {
		super();
		largeur = l;
		lMax = l - (2 * xt);
		hauteur = h;
		setBounds(x, y, l, h);
		texte = s;
		setText();
	}

	public void setText() {
		space = fontMetrics.stringWidth(" ");
		for (i = 0; i < 6; i++) {
			lignes[i] = "";
		}
		int z = 0;	// compteur de mots
		int y = 0;
		int x = texte.indexOf(32);
		int k = 0;
		while (x != -1) {	// mots[z] contient les (z + 1) mots 
									// de la phrase (de mots[0]  mots[z]
			mots[z] = texte.substring(y, x);
			z++;
			y = x + 1;
			x = texte.indexOf(32, y);
		}
		mots[z] = texte.substring(y, texte.length());
		i = 0;
		int l = 0;	// Numro de ligne
		int j = 0;	// Longueur de la ligne en cours de cration
		while (i <= z) { // Tant qu'il reste des mots
			if (j + fontMetrics.stringWidth(mots[i]) > lMax) {	// En 
							// ajoutant le mot suivant, on dpasse la ligne
				llignes[l] = j - space; // On enregistre la longueur de 
													// la ligne (moins le dernier 
													// espace)
				j = 0;	// On remet la longueur de ligne  0
				l++;	// On passe  la ligne suivante
			}
			else {
				j = j + fontMetrics.stringWidth(mots[i]) + space;
				lignes[l] = lignes[l] + mots[i] + " ";
				llignes[l] = j - space; // On enregistre la longueur de 
													// la ligne (moins le dernier 
													// espace)
				i ++;
			}
		}
		numLignes = l;	// nombre de lignes (exemple : 6 lignes, 
								// numrotes de 0  5)
		repaint();
	}

	public void paint(Graphics g) {
		g.setColor(bColor);
		g.fillRect(0, 0, largeur, hauteur);
		g.draw3DRect(0, 0, largeur - 1, hauteur - 1, true);
		
		g.setFont(labelFont);
		for (i = 0; i <= numLignes; i++) {
			g.setColor(fColorF);
			g.drawString(lignes[i], (xt + 1), ((yt + i * ht) + 1));
			g.setColor(fColorC);
			g.drawString(lignes[i], xt, (yt + i * ht));
		}
	}
}
