import java.io.*;

public class Serialisation {
	public static void main (String[] args) throws IOException {
		Voiture voiture = new Voiture("V6", "Cabriolet");
		voiture.setCarburant(50);
		FileOutputStream f = new FileOutputStream("garage");
		ObjectOutputStream o = new ObjectOutputStream(f);

		o.writeObject(voiture);
		o.close();
	}
}

class Voiture implements Serializable {
	Moteur moteur;
	Carrosserie carrosserie;
	transient int essence;
	
	Voiture (String m, String c) {
		moteur = new Moteur(m);
		carrosserie = new Carrosserie(c);
	}
	
	String getMoteur() {
		return moteur.getValeur();
	}
	
	String getCarrosserie() {
		return carrosserie.getValeur();
	}
	
	void setCarburant(int e) {
		essence += e;
	}
	
	int getCarburant() {
		return essence;
	}
}

class Carrosserie implements Serializable {
	String valeur;
	
	Carrosserie (String s) {
		valeur = s;
	}
	
	String getValeur() {
		return valeur;
	}
}

class Moteur implements Serializable {
	String valeur;
	
	Moteur (String s) {
		valeur = s;
	}
	
	String getValeur() {
		return valeur;
	}
}
