import java.io.*;

public class Clone2 {
	public static void main (String[] args) throws IOException {

		Voiture voiture = new Voiture();
		voiture.setCarburant(30);
		System.out.println(voiture.getCarburant());
		pleinSerial(voiture);
		System.out.println(voiture.getCarburant());
	}
	
	public static void pleinSerial(Voiture v) throws IOException {
		Voiture v2 = null;
		PipedInputStream pipedIn = new PipedInputStream();
		PipedOutputStream pipedOut = new PipedOutputStream(pipedIn);
		ObjectOutputStream objOutput = new ObjectOutputStream(pipedOut);
		ObjectInputStream objInput = new ObjectInputStream(pipedIn);

		objOutput.writeObject(v);
		try {
			v2 = (Voiture)objInput.readObject();
		}
		catch (ClassNotFoundException e) {
			e.printStackTrace();
		}
		objInput.close();
		objOutput.close();
		
		v2.setCarburant(100);
		System.out.println(v2.getCarburant());
	}		 
}

class Voiture implements Serializable {
	Reservoir reservoir;
	
	Voiture () {
		reservoir = new Reservoir();
	}
	
	void setCarburant(int e) {
		reservoir.setContenu(e);
	}
	
	int getCarburant() {
		return reservoir.getContenu();
	}
}

class Reservoir implements Serializable {
	private int contenu;
	
	public int getContenu() {
		return contenu;
	}
	
	public void setContenu(int e) {
		contenu = e;
	}
}
