import java.util.*;
import java.lang.reflect.*;

public class Animaux9 {
	public static void main(String[] argv) {
		Vector zoo = new Vector();
		int j = 0, chats = 0, chiens = 0, canaris = 0;
		Random r = new Random();
		Class[] ct = {Chien.class, Chat.class, Canari.class};
		for (int i = 0; i < 10;i++) {
			j = Math.abs(r.nextInt()) % 3;
			try {
				zoo.add(ct[j].newInstance());
			}
			catch(IllegalAccessException e) {
				e.printStackTrace(System.err);
			}
			catch(InstantiationException e) {
				e.printStackTrace(System.err);
			}				
		}
		Animal a;
		for (Enumeration e = zoo.elements() ; e.hasMoreElements() ;) {
			a = (Animal)(e.nextElement());
			for (j = 0; j < ct.length; j++) {
				if (a.getClass() == ct[j])
					break;
			}
			switch(++j) {
				case 1:
					System.out.print("Un chien : ");
					chiens++;
					break;
				case 2:
					System.out.print("Un chat : ");
					chats++;
					break;
				case 3:
					System.out.print("Un canari : ");
					canaris++;
			}
			a.crier();
			try {
				Method[] ma = a.getClass().getMethods();
				Method[] mAnimal = Animal.class.getMethods();
				Method m1 = ma[ma.length - 1];
				Method m2 = mAnimal[mAnimal.length - 1];
				if (!m1.getName().equals(m2.getName()))
					m1.invoke(a, new Object[0]);
			}
			catch(IllegalAccessException se) {
				System.out.println(se);
			}
			catch(InvocationTargetException se) {
				System.out.println(se);
			}
		}
		System.out.println("Total : " + chiens + " chien(s), " 
									+ chats + " chat(s) et " 
									+ canaris + " canari(s).");
	}
}
interface Animal {
	void crier();
}

class Canari implements Animal {
	public void crier() {
		System.out.println("Cui-cui !");
	}
}
class Chien implements Animal {
	public void crier() {
		System.out.println("Ouah-Ouah !");
	}
	public void grogner() {
		System.out.println("Grrrrrrr...");
	}
}
class Chat implements Animal {
	public void crier() {
		System.out.println("Miaou !");
	}
	public void ronronner() {
		System.out.println("Rrrr...Rrrr...");
	}
}
