import javax.swing.*;
import java.awt.event.*;
import java.awt.*;
import java.util.*;

public class Boutons2 {
	public static void main( String[] args ) {
		ChoixCouleur choix = new ChoixCouleur("Choisissez une couleur");
	}
}
	
class ChoixCouleur extends JFrame {
	JLabel L1;
	JButton B1, B2;
	Random random = new Random();
	Color c;
	
	ChoixCouleur(String s) {
		this(s, 12);
	}
	
	ChoixCouleur(String s, int t) {
		addWindowListener(new WindowAdapter() {
					public void windowClosing(WindowEvent e) {
						System.exit(0);
					}});
		addMouseListener(new MouseAdapter() {
				public void mouseClicked(MouseEvent e) {
					c = new Color(Math.abs(random.nextInt()) % 256,
								Math.abs(random.nextInt()) % 256, 
								Math.abs(random.nextInt()) % 256);
					getContentPane().setBackground(c);
					B1.setBackground(c);
					B2.setBackground(c);
					repaint();
				}});	
		Font f = new Font("Dialog", Font.BOLD, t);
		getContentPane().setLayout(new GridBagLayout());
		GridBagConstraints c = new GridBagConstraints();
		L1 = new JLabel(s);
		L1.setFont(f);
		c.weightx = 1;
		c.weighty = 1;
		c.gridwidth = GridBagConstraints.REMAINDER;
		c.gridheight = 1;
		getContentPane().add(L1, c);
		B1 = new JButton("Rouge");
		B1.addMouseListener(new MouseAdapter() {
				public void mouseClicked(MouseEvent e) {
					L1.setForeground(new Color(255, 0, 0));
					processMouseEvent(e);
				}});
		B1.setFont(f);
		c.gridwidth = 1;
		getContentPane().add(B1, c);
		B2 = new JButton("Bleu");
		B2.addMouseListener(new MouseAdapter() {
				public void mouseClicked(MouseEvent e) {
					L1.setForeground(new Color(0, 0, 255));
					processMouseEvent(e);
				}});
		B2.setFont(f);
		c.gridheight = GridBagConstraints.REMAINDER;
		getContentPane().add(B2, c);
		setup();	
		setResizable(false);
		setVisible(true);
	}
	
	protected void processMouseEvent(MouseEvent e) {
		super.processMouseEvent(e);
	}

	void setup() {
		int xB = Math.max(B1.getPreferredSize().width, B2.getPreferredSize().width);
		int yB = B1.getPreferredSize().height;
		B1.setPreferredSize(new Dimension(xB, yB));
		B1.setMaximumSize(new Dimension(xB, yB));
		B1.setMinimumSize(new Dimension(xB, yB));
		B2.setPreferredSize(new Dimension(xB, yB));
		B2.setMaximumSize(new Dimension(xB, yB));
		B2.setMinimumSize(new Dimension(xB, yB));
		int x = Math.max(L1.getPreferredSize().width, 2 * xB);
		int y = L1.getPreferredSize().height + yB;
		setSize((int)((x + 50) * 1.2), (int)((y + 20) * 1.8));

		Dimension tailleEcran = Toolkit.getDefaultToolkit().getScreenSize();
		int largeurEcran = tailleEcran.width;
		int hauteurEcran = tailleEcran.height;
		int largeur = getSize().width;
		int hauteur = getSize().height;
		int xPos = (largeurEcran - largeur) / 2;
		int yPos = (hauteurEcran - hauteur) / 2;
		setLocation(xPos, yPos);
	}
}
