import java.awt.*;
import java.awt.event.*;
import java.util.*;
import java.beans.*;
import javax.swing.*;
import javax.swing.event.*;


public class ExempleSwing {
	static AppFrame frame;
	public static void main( String[] args ) {
		frame = new AppFrame("Exemple de composants Swing", 640, 480);
		frame.setVisible(true);
	}
}


class AppFrame extends JFrame {
	int xPos;
	int yPos;
	JDesktopPane desktop;
	Color BCouleur, FCouleur;
	SelecteurCouleur sc = null;
	
	AppFrame(String s, int l, int h) {
		super(s);
		desktop = new JDesktopPane();
		getContentPane().add(desktop);
		xPos = (Background.largeurEcran - l) / 2;
		yPos = (Background.hauteurEcran - h) / 2;
		addWindowListener(new WindowAdapter() {
					public void windowClosing(WindowEvent e) {
						System.exit(0);
					}});
		BCouleur = new Color(255, 255, 255);
		FCouleur = new Color(192, 192, 192);
		desktop.setBackground(BCouleur);
		setBounds(xPos, yPos, l, h);
		
		JMenu menu = new JMenu("Commandes", true);
		JMenuItem item1 = new JMenuItem("Couleurs");
		item1.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					sc = SelecteurCouleur.create(AppFrame.this);
					if (!(sc == null)) {
						desktop.add(sc);
						try { 
							sc.setSelected(true); 
						} catch (PropertyVetoException ve) {}
					}
				}});
		menu.add(item1);
		JMenuItem item2 = new JMenuItem("Ouvrir");
		item2.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					BD bd = new BD("Bote de dialogue", AppFrame.this);
					desktop.add(bd);
					try { 
						bd.setSelected(true); 
					} catch (PropertyVetoException ve) {}
				}});
		menu.add(item2);
		menu.add(new JSeparator());
		JMenuItem item3 = new JMenuItem("Quitter");
		item3.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					System.exit(0);
				}});
		menu.add(item3);
		JMenuBar mb = new JMenuBar();
		mb.add(menu);

		JMenu menu2 = new JMenu("Look & Feel", true);
		JMenuItem item11 = new JMenuItem("Metal");
		item11.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					changePlaf(1);
				}});
		menu2.add(item11);
		JMenuItem item12 = new JMenuItem("Motif");
		item12.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					changePlaf(2);
				}});
		menu2.add(item12);
		JMenuItem item13 = new JMenuItem("Windows");
		item13.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					changePlaf(3);
				}});
		menu2.add(item13);
		JMenuItem item14 = new JMenuItem("Macintosh");
		item14.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					changePlaf(4);
				}});
		menu2.add(item14);
		mb.add(menu2);

		setJMenuBar(mb);
	}
	
	void changePlaf(int s) {
	    try {
			switch (s) {
				case 1:
					UIManager.setLookAndFeel("javax.swing.plaf.metal.MetalLookAndFeel");
					break;
				case 2:
					UIManager.setLookAndFeel("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
					break;
				case 3:
					UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
					break;
				case 4:
					//UIManager.setLookAndFeel("com.sun.java.plaf.mac.MacLookAndFeel");
					break;
			}
			SwingUtilities.updateComponentTreeUI(this);
		}  
		catch (UnsupportedLookAndFeelException e) {
		    System.out.println("Ce Look & Feel n'est pas disponible sur votre systme.");
		}
		catch (IllegalAccessException e) {
		    System.out.println("Ce Look & Feel n'est pas accessible sur votre systme.");
		}
		catch (ClassNotFoundException e) {
		    System.out.println("Ce Look & Feel n'a pas t trouv.");
		}   
		catch (InstantiationException e) {
		    System.out.println("Ce Look & Feel ne peut tre instanci.");
		}
		catch (Exception e) {
		    System.out.println("Erreur d'excution.");
		}
	}
}

class BD extends JInternalFrame {
	static int compte = 0;
	JLabel L1;
	JButton B1, B2;
	JFrame parent;
	Color couleur;
	
	BD(String s, AppFrame p) {
		super(s, false, true, false, false);
		parent = p;
		couleur = p.FCouleur;
		getContentPane().setBackground(couleur);
		addInternalFrameListener(new InternalFrameAdapter() {
				public void internalFrameClosing(InternalFrameEvent e) {
					dispose();
				}});
		Font f = new Font("Dialog", Font.BOLD, 12);
		getContentPane().setLayout(new GridBagLayout());
		GridBagConstraints c = new GridBagConstraints();
		L1 = new JLabel(s);
		L1.setFont(f);
		c.weightx = 1;
		c.weighty = 1;
		c.gridwidth = GridBagConstraints.REMAINDER;
		c.gridheight = 1;
		getContentPane().add(L1, c);
		B1 = new JButton("Rouge");
		B1.setBackground(couleur);
		B1.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					L1.setForeground(new Color(255, 0, 0));
					repaint();
				}});
		B1.setFont(f);
		c.gridwidth = 1;
		getContentPane().add(B1, c);
		B2 = new JButton("Bleu");
		B2.setBackground(couleur);
		B2.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					L1.setForeground(new Color(0, 0, 255));
					repaint();
				}});
		B2.setFont(f);
		c.gridheight = GridBagConstraints.REMAINDER;
		getContentPane().add(B2, c);
		setup();	
		setResizable(false);
		setVisible(true);
	}	
	
	void setup() {
		int xB = Math.max(B1.getPreferredSize().width, B2.getPreferredSize().width);
		int yB = B1.getPreferredSize().height;
		B1.setPreferredSize(new Dimension(xB, yB));
		B1.setMaximumSize(new Dimension(xB, yB));
		B1.setMinimumSize(new Dimension(xB, yB));
		B2.setPreferredSize(new Dimension(xB, yB));
		B2.setMaximumSize(new Dimension(xB, yB));
		B2.setMinimumSize(new Dimension(xB, yB));
		int x = Math.max(L1.getPreferredSize().width, 2 * xB);
		int y = L1.getPreferredSize().height + yB;
		setSize((int)((x + 50) * 1.2), (int)((y + 20) * 1.8));
		int w = (10 + 10 * (compte++ % 10));
		setLocation(w, w);
	}
}

class SelecteurCouleur extends JInternalFrame {
	static int ninstances = 0;
	JLabel C1, C2, C3;
	JButton B1, B2;
	JSlider S1, S2, S3;
	JCheckBox CB1, CB2;
	ButtonGroup bg;
	JPanel panel, panel2;
	int cr, cv, cb, cr0, cv0, cb0;
	Color precBCouleur, precFCouleur;
	AppFrame parent;
	boolean fond = false;
	boolean contenu = true;
	
	public static SelecteurCouleur create(AppFrame p) {
		if (ninstances == 0) {
			ninstances++;
			return new SelecteurCouleur(p);
		}
		else {
			return null;
		}
	}
	
	private SelecteurCouleur(AppFrame p) {
		super("Selecteur de couleur", false, true, false, false);
		addInternalFrameListener(new InternalFrameAdapter() {
				public void internalFrameClosing(InternalFrameEvent e) {
					ninstances = 0;
					dispose();
				}});
		parent = p;
		precBCouleur = parent.BCouleur;
		precFCouleur = parent.FCouleur;
		cr = precFCouleur.getRed();
		cv = precFCouleur.getGreen();
		cb = precFCouleur.getBlue();
		cr0 = cr;
		cv0 = cv;
		cb0 = cb;
		C1 = new JLabel("Rouge");
		C2 = new JLabel("Vert");
		C3 = new JLabel("Bleu");
		bg = new ButtonGroup();
		CB1 = new JCheckBox("Arrire plan", false);
		CB1.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					cr = cr0;
					cv = cv0;
					cb = cb0;
					changeCouleur();
					fond = true;
					contenu = false;
					cr = precBCouleur.getRed();
					cv = precBCouleur.getGreen();
					cb = precBCouleur.getBlue();
					S1.setValue(cr);
					S2.setValue(cv);
					S3.setValue(cb);					
					cr0 = cr;
					cv0 = cv;
					cb0 = cb;
				}});
		CB2 = new JCheckBox("fentres", true);
		CB2.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					cr = cr0;
					cv = cv0;
					cb = cb0;
					changeCouleur();
					fond = false;
					contenu = true;
					cr = precFCouleur.getRed();
					cv = precFCouleur.getGreen();
					cb = precFCouleur.getBlue();
					S1.setValue(cr);
					S2.setValue(cv);
					S3.setValue(cb);					
					cr0 = cr;
					cv0 = cv;
					cb0 = cb;
				}});
		bg.add(CB1);
		bg.add(CB2);
		S1 = new JSlider(SwingConstants.HORIZONTAL, 0, 255, cr);
		S1.addChangeListener(new ChangeListener() {
				public void stateChanged(ChangeEvent e) {
					cr = S1.getValue();
					changeCouleur();
				}});
		S2 = new JSlider(SwingConstants.HORIZONTAL, 0, 255, cv);
		S2.addChangeListener(new ChangeListener() {
				public void stateChanged(ChangeEvent e) {
					cv = S2.getValue();
					changeCouleur();
				}});
		S3 = new JSlider(SwingConstants.HORIZONTAL, 0, 255, cb);
		S3.addChangeListener(new ChangeListener() {
				public void stateChanged(ChangeEvent e) {
					cb = S3.getValue();
					changeCouleur();
				}});
		B1 = new JButton("Appliquer");
		B1.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					cr0 = cr;
					cv0 = cv;
					cb0 = cb;
					if (contenu) {
						precFCouleur = new Color(cr, cv, cb);
						parent.FCouleur = precFCouleur;
						changeCouleur();
					}
				}});
		B2 = new JButton("Annuler");
		B2.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					cr = cr0;
					cv = cv0;
					cb = cb0;
					S1.setValue(cr);
					S2.setValue(cv);
					S3.setValue(cb);					
				}});
		panel = new JPanel();
		panel.add(B1);
		panel.add(B2);
		panel2 = new JPanel();
		panel2.add(CB1);
		panel2.add(CB2);
				
		getContentPane().setLayout(new GridBagLayout());
		GridBagConstraints c = new GridBagConstraints();
		c.weighty = 1;
		c.weightx = 1;
		c.gridwidth = GridBagConstraints.REMAINDER;
		getContentPane().add(panel2, c);
		c.weightx = 0;
		c.anchor = GridBagConstraints.EAST;
		c.gridwidth = GridBagConstraints.RELATIVE;
		c.gridheight = 1;
		getContentPane().add(C1, c);
		c.weightx = 1;
		c.gridwidth = GridBagConstraints.REMAINDER;
		c.fill = GridBagConstraints.HORIZONTAL;
		getContentPane().add(S1, c);
		c.weightx = 0;
		c.fill = GridBagConstraints.NONE;
		c.gridwidth = GridBagConstraints.RELATIVE;
		c.gridheight = 1;
		getContentPane().add(C2, c);
		c.weightx = 1;
		c.gridwidth = GridBagConstraints.REMAINDER;
		c.fill = GridBagConstraints.HORIZONTAL;
		getContentPane().add(S2, c);
		c.weightx = 0;
		c.fill = GridBagConstraints.NONE;
		c.gridwidth = GridBagConstraints.RELATIVE;
		c.gridheight = 1;
		getContentPane().add(C3, c);
		c.weightx = 1;
		c.gridwidth = GridBagConstraints.REMAINDER;
		c.fill = GridBagConstraints.HORIZONTAL;
		getContentPane().add(S3, c);
		c.fill = GridBagConstraints.NONE;
		c.anchor = GridBagConstraints.CENTER;		
		c.gridheight = GridBagConstraints.REMAINDER;
		getContentPane().add(panel, c);
		setup();	
		setResizable(false);
		changeCouleur();
		setVisible(true);
	}	
	
	void setup() {
		int xB = Math.max(B1.getPreferredSize().width, B2.getPreferredSize().width);
		int yB = B1.getPreferredSize().height;
		B1.setPreferredSize(new Dimension(xB, yB));
		B1.setMaximumSize(new Dimension(xB, yB));
		B1.setMinimumSize(new Dimension(xB, yB));
		B2.setPreferredSize(new Dimension(xB, yB));
		B2.setMaximumSize(new Dimension(xB, yB));
		B2.setMinimumSize(new Dimension(xB, yB));
		int l = Math.max(C1.getPreferredSize().width, 2 * xB);
		int h = C1.getPreferredSize().height + yB;
		l = (int)((l + 50) * 1.2);
		h = (int)((h + 20) * 3);
		int x = (int)((parent.getSize().width - l) / 2);
		int y = (int)((parent.getSize().height - l) / 1.8);
		setBounds(x, y, l, h);
	}
	
	void changeCouleur() {
		if (fond) {
			precBCouleur = new Color(cr, cv, cb);
			parent.BCouleur = precBCouleur;
			parent.desktop.setBackground(parent.BCouleur);
		}
		else {
			precFCouleur = new Color(cr, cv, cb);
			setBackground(precFCouleur);
			panel.setBackground(precFCouleur);
			panel2.setBackground(precFCouleur);
			S1.setBackground(precFCouleur);
			S2.setBackground(precFCouleur);
			S3.setBackground(precFCouleur);
			B1.setBackground(precFCouleur);
			B2.setBackground(precFCouleur);
			CB1.setBackground(precFCouleur);
			CB2.setBackground(precFCouleur);
		}
		parent.repaint();
	}
}
