import javax.swing.*;
import javax.swing.event.*;
import java.awt.event.*;
import java.awt.*;
import java.util.*;

public class Menus2 extends JFrame {
	public static void main( String[] args ) {
		MaFenetre fenetre = new MaFenetre("Exemple de menus");
	}
}
	

class MaFenetre extends JFrame {
	JDesktopPane desktop;
	MaFenetre(String s) {
		super(s);
		addWindowListener(new WindowAdapter() {
					public void windowClosing(WindowEvent e) {
						System.exit(0);
					}});
		setup();
		

		JMenu menu = new JMenu("Commandes", true);
		JMenuItem item1 = new JMenuItem("Ouvrir");
		item1.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					BD bd = new BD("Affiche par Commandes/Ouvrir");
					desktop.add(bd);
					try { 
						bd.setSelected(true); 
					} catch (java.beans.PropertyVetoException ve) {}
				}});
		menu.add(item1 );
		JMenuItem item2 = new JMenuItem("Ouvrir aussi");
		item2.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					BD bd = new BD("Affiche par Commandes/Ouvrir aussi");
					desktop.add(bd);
					try { 
						bd.setSelected(true); 
					} catch (java.beans.PropertyVetoException ve) {}
				}});
		menu.add(item2 );
		menu.add(new JSeparator());
		JMenuItem item3 = new JMenuItem("Quitter");
		item3.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					System.exit(0);
				}});
		menu.add(item3 );
		JMenuBar mb = new JMenuBar();
		mb.add(menu);
		setJMenuBar(mb);
		
		desktop = new JDesktopPane();
		getContentPane().add(desktop);

		setVisible(true);
	}
	

	void setup() {
		int largeur = 400, hauteur = 300;
		setSize(largeur, hauteur);

		Dimension tailleEcran = Toolkit.getDefaultToolkit().getScreenSize();
		int largeurEcran = tailleEcran.width;
		int hauteurEcran = tailleEcran.height;
		int xPos = (largeurEcran - largeur) / 2;
		int yPos = (hauteurEcran - hauteur) / 2;
		setLocation(xPos, yPos);
	}
}


class BD extends JInternalFrame {
	static int compte = 0;
	JLabel L1;
	JButton B1, B2;
	
	BD(String s) {
		super(s, false, true, false, false);
		addInternalFrameListener(new InternalFrameAdapter() {
					public void internalFrameClosing(InternalFrameEvent e) {
						dispose();
					}});
		Font f = new Font("Dialog", Font.BOLD, 12);
		getContentPane().setLayout(new GridBagLayout());
		GridBagConstraints c = new GridBagConstraints();
		L1 = new JLabel(s);
		L1.setFont(f);
		c.weightx = 1;
		c.weighty = 1;
		c.gridwidth = GridBagConstraints.REMAINDER;
		c.gridheight = 1;
		getContentPane().add(L1, c);
		B1 = new JButton("Rouge");
		B1.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					L1.setForeground(new Color(255, 0, 0));
					repaint();
				}});
		B1.setFont(f);
		c.gridwidth = 1;
		getContentPane().add(B1, c);
		B2 = new JButton("Bleu");
		B2.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					L1.setForeground(new Color(0, 0, 255));
					repaint();
				}});
		B2.setFont(f);
		c.gridheight = GridBagConstraints.REMAINDER;
		getContentPane().add(B2, c);
		setup();	
		setResizable(false);
		setBackground(Color.lightGray);
		setVisible(true);
	}	
	

	void setup() {
		int xB = Math.max(B1.getPreferredSize().width, B2.getPreferredSize().width);
		int yB = B1.getPreferredSize().height;
		B1.setPreferredSize(new Dimension(xB, yB));
		B1.setMaximumSize(new Dimension(xB, yB));
		B1.setMinimumSize(new Dimension(xB, yB));
		B2.setPreferredSize(new Dimension(xB, yB));
		B2.setMaximumSize(new Dimension(xB, yB));
		B2.setMinimumSize(new Dimension(xB, yB));
		int x = Math.max(L1.getPreferredSize().width, 2 * xB);
		int y = L1.getPreferredSize().height + yB;
		setSize((int)((x + 50) * 1.2), (int)((y + 20) * 1.8));
		int w = (10 + 10 * (compte++ % 10));
		setLocation(w, w);
	}
}
