import javax.swing.*;
import java.awt.event.*;
import java.awt.*;

public class Question extends JFrame {
	JLabel L1;
	JButton B1, B2, B3;
	Question(String s) {
		this(s, 12);
	}
	
	Question(String s, int t) {
		addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				System.exit(0);
			}});
		Font f = new Font("Dialog", Font.BOLD, t);
		getContentPane().setLayout(new GridBagLayout());
		GridBagConstraints c = new GridBagConstraints();
		L1 = new JLabel(s);
		L1.setFont(f);
		c.weightx = 1;
		c.weighty = 1;
		c.gridwidth = GridBagConstraints.REMAINDER;
		c.gridheight = 1;
		getContentPane().add(L1, c);
		B1 = new JButton("Oui");
		B1.setFont(f);
		c.gridwidth = 1;
		getContentPane().add(B1, c);
		B2 = new JButton("Je ne sais pas");
		B2.setFont(f);
		c.gridwidth = 2;
		getContentPane().add(B2, c);
		B3 = new JButton("Non");
		B3.setFont(f);
		c.gridheight = GridBagConstraints.REMAINDER;
		getContentPane().add(B3, c);
		setup();	
		setVisible(true);
		setResizable(false);
	}

	void setup() {
		int xB = Math.max(B1.getPreferredSize().width, B3.getPreferredSize().width);
		int yB = B1.getPreferredSize().height;
		int xB2 = B2.getPreferredSize().width;
		B1.setPreferredSize(new Dimension(xB, yB));
		B1.setMaximumSize(new Dimension(xB, yB));
		B1.setMinimumSize(new Dimension(xB, yB));
		B3.setPreferredSize(new Dimension(xB, yB));
		B3.setMaximumSize(new Dimension(xB, yB));
		B3.setMinimumSize(new Dimension(xB, yB));
		int x = Math.max(L1.getPreferredSize().width, 2 * xB + xB2);
		int y = L1.getPreferredSize().height + yB;
		setSize((int)((x + 50) * 1.2), (int)((y + 20) * 1.8));

		Dimension tailleEcran = Toolkit.getDefaultToolkit().getScreenSize();
		int largeurEcran = tailleEcran.width;
		int hauteurEcran = tailleEcran.height;
		int largeur = getSize().width;
		int hauteur = getSize().height;
		int xPos = (largeurEcran - largeur) / 2;
		int yPos = (hauteurEcran - hauteur) / 2;
		setLocation(xPos, yPos);
	}
}
