import java.awt.*;
import java.awt.event.*;
import com.sun.java.swing.*;

public class AfficheImage2 {
	static Tableau frame;
		public static void main( String[] args ) {
		frame = new Tableau();
		frame.setVisible(true);
	}
}

class Tableau extends JFrame {

	static final Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
	static final int largeurEcran = screenSize.width;
	static final int hauteurEcran = screenSize.height + 2;
	Container pane;
	int l, h;
	
	public Tableau() {
		super();
		pane = getContentPane();
		pane.setLayout(new FlowLayout());
		this.addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				System.exit(0);
			}});
		
		PhotoCanvas photo = new PhotoCanvas("voiture.jpg");
		l = photo.getWidth();
		h = photo.getHeight();
		setBounds((largeurEcran - l) / 2, (hauteurEcran - h) / 2, l, h);
		pane.add(photo);
	}
}

class PhotoCanvas extends Canvas {
	Image image;
	
	public PhotoCanvas(String s) {
		image = getToolkit().getImage(s);
		MediaTracker tracker = new MediaTracker(this);
		tracker.addImage(image, 0);
		try {
			tracker.waitForAll();
		}
		catch(InterruptedException e) {
			System.out.println(e);
		}
		setSize(image.getWidth(this), image.getHeight(this));
	}
	
	public void paint(Graphics g) {
		g.drawImage(image, 0, 0, this);
	}
}
