import java.awt.*;
import java.awt.event.*;
import com.sun.java.swing.*;
import java.awt.image.*;

public class AfficheImage3 {
	static Tableau frame;
		public static void main( String[] args ) {
		frame = new Tableau();
		frame.setVisible(true);
	}
}

class Tableau extends JFrame {
	Container pane;
	
	public Tableau() {
		super();
		pane = getContentPane();
		pane.setLayout(new FlowLayout());
		this.addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				System.exit(0);
			}});
		
		PhotoCanvas photo = new PhotoCanvas("voiture.jpg");
		pane.add(photo);
	}
	
}

class PhotoCanvas extends Canvas {
	static final Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
	static final int largeurEcran = screenSize.width;
	static final int hauteurEcran = screenSize.height + 2;
	Image image;
	
	public PhotoCanvas(String s) {
		image = getToolkit().getImage(s);
		prepareImage(image, this);
	}
	
	public void paint(Graphics g) {
		g.drawImage(image, 0, 0, this);
	}
	
	public boolean imageUpdate(Image image, int info, int x, int y, int l, int h) {
		if ((info & (WIDTH | HEIGHT)) != 0) {
			setSize(l, h);
			getParent().getParent().getParent().getParent().
											setBounds((largeurEcran - l) / 2, 
											(hauteurEcran - h) / 2, l, h);
		}
		if ((info & (ERROR | FRAMEBITS | ALLBITS)) != 0) {
			repaint();
			return false;
		}
		else {
			return true;
		}
	}
}
