import java.awt.*;
import java.awt.event.*;
import com.sun.java.swing.*;
import java.beans.*;
import com.sun.java.swing.event.*;
import java.awt.geom.*;

public class Graphisme4 {
	static Tableau frame;
		public static void main( String[] args ) {
		frame = new Tableau();
		frame.setVisible(true);
	}
}

class Tableau extends JFrame {
	static final Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
	static final int largeurEcran = screenSize.width;
	static final int hauteurEcran = screenSize.height + 2;
	int l = 640;
	int h = 480;
	JDialog sc = null;
	Color BCouleur = new Color(255, 255, 255);
	Color FCouleur = new Color(127, 127, 127);
	Tableau moi;
	Canvas dessin;
	Container pane;
	JButton couleur;
	JCheckBox plein, vide, relief, plat;
	ButtonGroup bg3D, bgContour;
	boolean is3D, isContour;
	JPanel panelHaut;
	int x1, y1, x2, y2;
	
	public Tableau() {
		super();
		pane = getContentPane();
		this.addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				System.exit(0);
			}});
		setBackground(BCouleur);
		moi = this;
		setBounds ((largeurEcran - l) / 2, (hauteurEcran - h) / 2, l, h);
		pane.setBackground(BCouleur);
		bgContour = new ButtonGroup();
		bg3D = new ButtonGroup();
		couleur = new JButton("Couleur");
		couleur.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					sc = SelecteurCouleur.create(moi);
				}});
		vide = new JCheckBox("Contour", false);

		vide.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					isContour = true;
				}});
		plein = new JCheckBox("Fond", true);
		plein.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					isContour = false;
				}});
		plein.setPreferredSize(vide.getPreferredSize());
		plat = new JCheckBox("2D", true);
		plat.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					is3D = false;
				}});
		plat.setPreferredSize(vide.getPreferredSize());
		relief = new JCheckBox("3D", false);
		relief.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					is3D = true;
				}});
		relief.setPreferredSize(vide.getPreferredSize());
		bgContour.add(vide);
		bgContour.add(plein);
		bg3D.add(plat);
		bg3D.add(relief);
		panelHaut = new JPanel();
		panelHaut.add(vide);
		panelHaut.add(plein);
		panelHaut.add(plat);
		panelHaut.add(relief);
		panelHaut.add(couleur);
		pane.add(panelHaut, BorderLayout.NORTH); 

		dessin = new Canvas() {
			public void paint(Graphics g) {
			Graphics2D g2 = (Graphics2D)g;
			float[] motif = {5.0f};
			BasicStroke pointill = new BasicStroke(2.0f, 
												BasicStroke.CAP_BUTT, 
												BasicStroke.JOIN_MITER, 
												5.0f, motif, 0.0f);
				if (x2 == 0)
					return;
				int x = Math.min(x1, x2);
				int y = Math.min(y1, y2);
				int l =	Math.max(x1, x2) - x;
				int h = Math.max(y1, y2) - y;
				g.setColor(FCouleur);
				if (is3D) {
					if (isContour) {
						g.draw3DRect(x, y, l, h, true);
					}
					else {
						g.fill3DRect(x, y, l, h, true);
					}
				}
				else {
					if (isContour) {
						g2.setStroke(pointill);
						g2.draw(new Rectangle2D.Float (x, y, l, h));
					}
					else {
						g.fillRect(x, y, l, h);
					}
				}
			}};
		dessin.addMouseListener(new MouseAdapter() {
			public void mousePressed(MouseEvent e) {
				x1 = e.getX();
				y1 = e.getY();
				x2 = 0;
				y2 = 0;
			}});
		dessin.addMouseMotionListener(new MouseMotionAdapter() {
			public void mouseDragged(MouseEvent e) {
				x2 = e.getX();
				y2 = e.getY();
				dessin.repaint();
			}});
			
		pane.add(dessin, BorderLayout.CENTER);
	}
}

class SelecteurCouleur extends JDialog {
	static int nInstances = 0;
	JLabel C1, C2, C3;
	JButton B1, B2;
	JSlider S1, S2, S3;
	JPanel panel, panel2;
	int cr, cv, cb, cr0, cv0, cb0;
	Color precFCouleur;
	Tableau parent;
	Sample sample;
	
	public static SelecteurCouleur create(Tableau t) {
		if (nInstances == 0) {
			nInstances++;
			return new SelecteurCouleur(t);
		}
		else {
			return null;
		}
	}
	
	private SelecteurCouleur(Tableau t) {
		super(t, "Selecteur de couleur", true);
		parent = t;
		setDefaultCloseOperation(DISPOSE_ON_CLOSE);
		addWindowListener(new WindowAdapter() {
					public void windowClosed(WindowEvent e) {
						nInstances = 0;
					}});
		precFCouleur = parent.FCouleur;
		cr = precFCouleur.getRed();
		cv = precFCouleur.getGreen();
		cb = precFCouleur.getBlue();
		cr0 = cr;
		cv0 = cv;
		cb0 = cb;
		C1 = new JLabel("Rouge");
		C2 = new JLabel("Vert");
		C3 = new JLabel("Bleu");
		S1 = new JSlider(SwingConstants.HORIZONTAL, 0, 255, cr);
		S1.addChangeListener(new ChangeListener() {
				public void stateChanged(ChangeEvent e) {
					cr = S1.getValue();
					changeCouleur();
				}});
		S2 = new JSlider(SwingConstants.HORIZONTAL, 0, 255, cv);
		S2.addChangeListener(new ChangeListener() {
				public void stateChanged(ChangeEvent e) {
					cv = S2.getValue();
					changeCouleur();
				}});
		S3 = new JSlider(SwingConstants.HORIZONTAL, 0, 255, cb);
		S3.addChangeListener(new ChangeListener() {
				public void stateChanged(ChangeEvent e) {
					cb = S3.getValue();
					changeCouleur();
				}});
		B1 = new JButton("Appliquer");
		B1.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					cr0 = cr;
					cv0 = cv;
					cb0 = cb;
					precFCouleur = new Color(cr, cv, cb);
					parent.FCouleur = precFCouleur;
					changeCouleur();
					parent.dessin.repaint();
					dispose();
				}});
		B2 = new JButton("Annuler");
		B2.addActionListener(new ActionListener() {
				public void actionPerformed(ActionEvent e) {
					cr = cr0;
					cv = cv0;
					cb = cb0;
					S1.setValue(cr);
					S2.setValue(cv);
					S3.setValue(cb);
					dispose();					
				}});
		panel = new JPanel();
		panel.add(B1);
		panel.add(B2);
		panel2 = new JPanel();
		sample = new Sample();
		panel2.add(sample);
				
		getContentPane().setLayout(new GridBagLayout());
		GridBagConstraints c = new GridBagConstraints();
		c.weighty = 1;
		c.weightx = 1;
		c.gridwidth = GridBagConstraints.REMAINDER;
		getContentPane().add(panel2, c);
		c.weightx = 0;
		c.anchor = GridBagConstraints.EAST;
		c.gridwidth = GridBagConstraints.RELATIVE;
		c.gridheight = 1;
		getContentPane().add(C1, c);
		c.weightx = 1;
		c.gridwidth = GridBagConstraints.REMAINDER;
		c.fill = GridBagConstraints.HORIZONTAL;
		getContentPane().add(S1, c);
		c.weightx = 0;
		c.fill = GridBagConstraints.NONE;
		c.gridwidth = GridBagConstraints.RELATIVE;
		c.gridheight = 1;
		getContentPane().add(C2, c);
		c.weightx = 1;
		c.gridwidth = GridBagConstraints.REMAINDER;
		c.fill = GridBagConstraints.HORIZONTAL;
		getContentPane().add(S2, c);
		c.weightx = 0;
		c.fill = GridBagConstraints.NONE;
		c.gridwidth = GridBagConstraints.RELATIVE;
		c.gridheight = 1;
		getContentPane().add(C3, c);
		c.weightx = 1;
		c.gridwidth = GridBagConstraints.REMAINDER;
		c.fill = GridBagConstraints.HORIZONTAL;
		getContentPane().add(S3, c);
		c.fill = GridBagConstraints.NONE;
		c.anchor = GridBagConstraints.CENTER;		
		c.gridheight = GridBagConstraints.REMAINDER;
		getContentPane().add(panel, c);
		setup();	
		setResizable(false);
		changeCouleur();
		setVisible(true);
	}	
	
	void setup() {
		int xB = Math.max(B1.getPreferredSize().width, B2.getPreferredSize().width);
		int yB = B1.getPreferredSize().height;
		B1.setPreferredSize(new Dimension(xB, yB));
		B1.setMaximumSize(new Dimension(xB, yB));
		B1.setMinimumSize(new Dimension(xB, yB));
		B2.setPreferredSize(new Dimension(xB, yB));
		B2.setMaximumSize(new Dimension(xB, yB));
		B2.setMinimumSize(new Dimension(xB, yB));
		int l = Math.max(C1.getPreferredSize().width, 2 * xB);
		int h = C1.getPreferredSize().height + yB;
		l = (int)((l + 50) * 1.2);
		h = (int)((h + 20) * 3);
		int x = (int)((parent.getSize().width - l) / 2) + parent.getLocation().x;
		int y = (int)((parent.getSize().height - l) / 1.1) + parent.getLocation().y;
		setBounds(x, y, l, h);
	}
	
	void changeCouleur() {
		precFCouleur = new Color(cr, cv, cb);
		sample.setForeground(precFCouleur);
		sample.repaint();
	}
}

class Sample extends Canvas {
	Sample() {
		setSize(100,50);
	}
	
	public void paint(Graphics g) {
		g.fillRect(10, 10, getSize().width - 20, getSize().height - 20);
	}
}
