import java.awt.*;
import java.awt.event.*;
import com.sun.java.swing.*;
import java.net.*;
import com.sun.java.swing.text.html.*;
import com.sun.java.swing.event.*;

class Navigateur extends JFrame {

	static final Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
	static final int largeurEcran = screenSize.width;
	static final int hauteurEcran = screenSize.height + 2;
	static URL url;
	Container pane;
	JScrollPane scrollPane;
	JEditorPane navPane;
	
	public Navigateur() {
		super();
		pane = getContentPane();
		this.addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent e) {
				System.exit(0);
			}});
		this.addComponentListener(new ComponentAdapter() {
			public void componentResized(ComponentEvent e) {
				scrollPane.setSize(getWidth() - 8, getHeight() - 28);
			}});

		try {
			url = new URL("http://www.volga.fr/");
			navPane = new JEditorPane();
			navPane.setPage(url);
			scrollPane = new JScrollPane(navPane, 
									JScrollPane.VERTICAL_SCROLLBAR_AS_NEEDED, 
									JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
			scrollPane.setPreferredSize(new Dimension(600,450));
			pane.add(scrollPane);
		}
		catch(Exception e) {System.out.println(e);}
	}
	
	public static void main( String[] args ) {
		Navigateur frame = new Navigateur();
		frame.pack();
		int l = frame.getWidth();
		int h = frame.getHeight();
		frame.setBounds((largeurEcran - l) / 2, (hauteurEcran - h) / 2, l, h);
		frame.setVisible(true);
	}
}
