import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import org.apache.xalan.xslt.*;

public class DeptXML3 extends HttpServlet {
	
	public void doPost(	HttpServletRequest requete,
						HttpServletResponse reponse)
						throws IOException, ServletException {
							
		String styleSheet = "depttexte.xsl";
		String typeMIME   = "text/plain";
		String dept = requete.getParameter("dept");
		
		reponse.setContentType(typeMIME);
		PrintWriter pw = reponse.getWriter();
		String[] result = getResult(dept);
		
		StringBuffer buf = new StringBuffer();
		buf.append("<?xml version='1.0'?>");
		buf.append("<document>");
		buf.append("<titre>Les Dpartements Franais</titre>");
		buf.append("<departement>" + result[0] + "</departement>");
		buf.append("<code>" + result[1] + "</code>");
		buf.append("<region>" + result[2] + "</region>");
		buf.append("<prefecture>" + result[3] + "</prefecture>");
		buf.append("<indicatif>" + result[4] + "</indicatif>");
		buf.append("</document>");

		xslTransform(buf.toString(), pw, styleSheet);
	}
	
	private void xslTransform(String buffer, Writer pw, String styleSheet) {
		
		try {
			// Instanciation d'un XSLProcessor  l'aide de XSLTProcessorFactory
			XSLTProcessor processor = XSLTProcessorFactory.getProcessor();

			// 
			XSLTInputSource xmlSource 
					= new XSLTInputSource(new StringReader(buffer));
			XSLTInputSource xslSheet 
					= new XSLTInputSource(getServletConfig()
					.getServletContext()
					.getRealPath("/" + styleSheet));
			XSLTResultTarget xmlResult 
					= new XSLTResultTarget(pw);

			// Transformation XSL
			processor.process(xmlSource, xslSheet, xmlResult);
		}
		catch(org.xml.sax.SAXException se) {
			System.out.println(se);
		}
	}
	
	private String[] getResult(String s) {
		String[] result = {s, "89", "Bourgogne", "Auxerre", "03 86"};
		return result;
	}
}