import java.io.*;
import javax.servlet.*;
import javax.servlet.http.*;
import org.apache.xalan.xslt.*;
import org.apache.fop.apps.*;
import org.apache.fop.render.pdf.*;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;

public class DeptXSLFO extends HttpServlet {
	
	public void doPost(	HttpServletRequest requete,
						HttpServletResponse reponse)
						throws IOException, ServletException {
							
		String styleSheet = "deptfo.xsl";
		String typeMIME   = "application/pdf";
		String dept = requete.getParameter("dept");
		
		reponse.setContentType(typeMIME);
		PrintWriter pw = reponse.getWriter();
		String[] result = getResult(dept);
		
		StringBuffer buf = new StringBuffer();
		buf.append("<?xml version='1.0'?>");
		buf.append("<document>");
		buf.append("<titre>Les Dpartements Franais</titre>");
		buf.append("<departement>" + result[0] + "</departement>");
		buf.append("<code>" + result[1] + "</code>");
		buf.append("<region>" + result[2] + "</region>");
		buf.append("<prefecture>" + result[3] + "</prefecture>");
		buf.append("<indicatif>" + result[4] + "</indicatif>");
		buf.append("</document>");

		StringBuffer fobuf = new StringBuffer();
		StringWriter foWriter = new StringWriter();
		xslTransform(buf.toString(), foWriter, styleSheet);
		fobuf = foWriter.getBuffer();
//		System.out.println(fobuf.toString());
		xslfoRender(pw, fobuf.toString());
	}
	
	private void xslfoRender(Writer pw, String styleSheet) {
		InputSource inputSource = new InputSource(new StringReader(styleSheet));
		Parser parser = new org.apache.xerces.parsers.SAXParser();

		Driver driver = new Driver();
		driver.setRenderer("org.apache.fop.render.pdf.PDFRenderer", "Volga");
		driver.addElementMapping("org.apache.fop.fo.StandardElementMapping");
		driver.setWriter((PrintWriter)pw);
		try {
			driver.buildFOTree(parser, inputSource);
			driver.format();
			driver.render();
		}
		catch (FOPException FOPe) {
			System.out.println(FOPe);
		}
		catch (IOException FOPe) {
			System.out.println(FOPe);
		}
	}

	private void xslTransform(String buffer, Writer pw, String styleSheet) {
		
		try {
			// Instanciation d'un XSLProcessor  l'aide de XSLTProcessorFactory
			XSLTProcessor processor = XSLTProcessorFactory.getProcessor();

			// 
			XSLTInputSource xmlSource 
					= new XSLTInputSource(new StringReader(buffer));
			XSLTInputSource xslSheet 
					= new XSLTInputSource(getServletConfig()
					.getServletContext()
					.getRealPath("/" + styleSheet));
			XSLTResultTarget xmlResult 
					= new XSLTResultTarget(pw);

			// Transformation XSL
			processor.process(xmlSource, xslSheet, xmlResult);
		}
		catch(org.xml.sax.SAXException se) {
			System.out.println(se);
		}
	}
	
	private String[] getResult(String s) {
		String[] result = {s, "89", "Bourgogne", "Auxerre", "03 86"};
		return result;
	}
}