# Module commande des moteurs carte Codo
# Attention, les explictions sur le livre sont données avec l'avant du robot vers les roues!
# Les commandes ici sont données avec l'avant vers la carte Microbit.
from microbit import *
from micropython import const
#pilotage des moteurs en mode tout ou rien
def avancer_d():
    pin13.write_digital(0)
    pin14.write_digital(1)
    pin15.write_digital(0)
    pin16.write_digital(1)
def reculer_d():
    pin13.write_digital(1)
    pin14.write_digital(0)
    pin15.write_digital(1)
    pin16.write_digital(0)
def pivoter_gauche_d():
    pin13.write_digital(1)
    pin14.write_digital(0)
    pin15.write_digital(0)
    pin16.write_digital(1)
def pivoter_droite_d():
    pin13.write_digital(0)
    pin14.write_digital(1)
    pin15.write_digital(1)
    pin16.write_digital(0)
def virer_gauche_d():
    pin13.write_digital(0)
    pin14.write_digital(0)
    pin15.write_digital(0)
    pin16.write_digital(1)
def virer_droite_d():
    pin13.write_digital(0)
    pin14.write_digital(1)
    pin15.write_digital(0)
    pin16.write_digital(0)
def stop():
    pin13.write_digital(0)
    pin14.write_digital(0)
    pin15.write_digital(0)
    pin16.write_digital(0)

#pilotage des moteurs avec gestion de la vitesse entre 0 et 100
def reculer_v(vitesse):
    pin13.set_analog_period(4)
    pin15.set_analog_period(4)
    pin13.write_analog(vitesse/100*1023)
    pin14.write_digital(0)
    pin15.write_analog(vitesse/100*1023)
    pin16.write_digital(0)
def avancer_v(vitesse):
    pin14.set_analog_period(4)
    pin16.set_analog_period(4)
    pin14.write_analog(vitesse/100*1023)
    pin13.write_digital(0)
    pin16.write_analog(vitesse/100*1023)
    pin15.write_digital(0)
def pivoter_droite_v(vitesse):
    pin14.set_analog_period(4)
    pin15.set_analog_period(4)
    pin14.write_analog(vitesse/100*1023)
    pin13.write_digital(0)
    pin15.write_analog(vitesse/100*1023)
    pin16.write_digital(0)
def pivoter_gauche_v(vitesse):
    pin13.set_analog_period(4)
    pin16.set_analog_period(4)
    pin13.write_analog(vitesse/100*1023)
    pin14.write_digital(0)
    pin16.write_analog(vitesse/100*1023)
    pin14.write_digital(0)
def virer_droite_v(vitesse):
    pin14.set_analog_period(4)
    pin14.write_analog(vitesse/100*1023)
    pin13.write_digital(0)
    pin15.write_digital(0)
    pin16.write_digital(0)
def virer_gauche_v(vitesse):
    pin6.set_analog_period(4)
    pin16.write_analog(vitesse/100*1023)
    pin14.write_digital(0)
    pin13.write_digital(0)
    pin15.write_digital(0)

#gestion des moteurs pour parcours une distance en cm
#le coefficient TAUX_DISTANCE est a adapter en fonction de votre robot
TAUX_DISTANCE = const(35)
def reculer(distance_cm):
    reculer_v(50) #adapter la vitesse si nécessaire
    sleep(int(distance_cm/TAUX_DISTANCE*1000))
    stop()
def avancer(distance_cm):
    avancer_v(50) #adapter la vitesse si nécessaire
    sleep(int(distance_cm/TAUX_DISTANCE*1000))
    stop()

#gestion de la rotation du robot en fonction d'un angle
TAUX_ROTATION=const(6) #à adapter en fonction de votre robot
def pivoter_droite(angle):
    pivoter_droite_v(20) #adapter la vitesse si nécessaite pour ajuster
    sleep(int(angle*TAUX_ROTATION))
    stop()
def pivoter_gauche(angle):
    pivoter_gauche_v(20) #adapter la vitesse si nécessaite pour ajuster
    sleep(int(angle*TAUX_ROTATION))
    stop()

#commande de la position du stylo
def lever_stylo():
    pin0.set_analog_period(20)
    pin0.write_analog(70) #valeur à adpater pour votre hauteur
def baisser_stylo():
    pin0.set_analog_period(20)
    pin0.write_analog(100) #valeur à adapter pour que le stylo touche le sol
