/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.forum;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class ConnecteurForum {
    private String driver = "com.mysql.jdbc.Driver";
    private String chaineConnexion = "jdbc:mysql:///test";
    private String login;
    private String password;
    private Connection connexion;

    public void setDriver(String string) throws SQLException {
        this.driver = string;
        this.fermerConnexion();
    }

    public void setChaineConnexion(String string) throws SQLException {
        this.chaineConnexion = string;
        this.fermerConnexion();
    }

    public void setLogin(String string) throws SQLException {
        this.login = string;
        this.fermerConnexion();
    }

    public void setPassword(String string) throws SQLException {
        this.password = string;
        this.fermerConnexion();
    }

    public void fermerConnexion() throws SQLException {
        if (this.connexion != null && !this.connexion.isClosed()) {
            this.connexion.close();
        }
    }

    public Connection getConnexion() throws SQLException {
        try {
            if (this.connexion == null || this.connexion.isClosed()) {
                Class.forName(this.driver);
                this.connexion = this.login != null ? DriverManager.getConnection(this.chaineConnexion, this.login, this.password) : DriverManager.getConnection(this.chaineConnexion);
                this.verifierTables(this.connexion);
            }
            return this.connexion;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SQLException("Classe introuvable " + classNotFoundException.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void verifierTables(Connection connection) throws SQLException {
        Statement statement;
        if (!this.verifierTable(connection, "UTILISATEUR")) {
            statement = null;
            try {
                statement = connection.createStatement();
                statement.executeUpdate("CREATE TABLE UTILISATEUR (PSEUDONYME CHAR(30), MOTDEPASSE CHAR(30), AUTORISATION CHAR(1))");
                statement.executeUpdate("CREATE INDEX INDEXPSEUDO ON UTILISATEUR (PSEUDONYME)");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        if (!this.verifierTable(connection, "MESSAGE")) {
            statement = null;
            try {
                statement = connection.createStatement();
                statement.executeUpdate("CREATE TABLE MESSAGE (ID INTEGER, AUTEUR CHAR(30), DATECREATION TIMESTAMP, SUJET VARCHAR(255), TEXTE VARCHAR(4000))");
                statement.executeUpdate("CREATE INDEX INDEXDATE ON MESSAGE (DATECREATION)");
                statement.executeUpdate("CREATE INDEX INDEXID ON MESSAGE (ID)");
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean verifierTable(Connection connection, String string) throws SQLException {
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        ResultSet resultSet = null;
        try {
            resultSet = databaseMetaData.getTables(connection.getCatalog(), null, string, null);
            boolean bl = resultSet.next();
            return bl;
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
        }
    }
}

