/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.forum;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class ConnecteurForum {
    private String driver = "com.mysql.jdbc.Driver";
    private String chaineConnexion = "jdbc:mysql:///test";
    private String login;
    private String password;
    private Connection connexion;

    public void setDriver(String string) throws SQLException {
        this.driver = string;
        this.fermerConnexion();
    }

    public void setChaineConnexion(String string) throws SQLException {
        this.chaineConnexion = string;
        this.fermerConnexion();
    }

    public void setLogin(String string) throws SQLException {
        this.login = string;
        this.fermerConnexion();
    }

    public void setPassword(String string) throws SQLException {
        this.password = string;
        this.fermerConnexion();
    }

    public void fermerConnexion() throws SQLException {
        if (this.connexion != null && !this.connexion.isClosed()) {
            this.connexion.close();
        }
    }

    public Connection getConnexion() throws SQLException {
        try {
            if (this.connexion == null || this.connexion.isClosed()) {
                Class.forName(this.driver);
                this.connexion = this.login != null ? DriverManager.getConnection(this.chaineConnexion, this.login, this.password) : DriverManager.getConnection(this.chaineConnexion);
                this.verifierTables(this.connexion);
            }
            return this.connexion;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SQLException("Classe introuvable " + classNotFoundException.getMessage());
        }
    }

    protected void verifierTables(Connection connection) throws SQLException {
        Throwable throwable;
        Statement statement;
        if (!this.verifierTable(connection, "UTILISATEUR")) {
            statement = connection.createStatement();
            throwable = null;
            try {
                statement.executeUpdate("CREATE TABLE UTILISATEUR (PSEUDONYME CHAR(30), MOTDEPASSE CHAR(30), AUTORISATION CHAR(1))");
                statement.executeUpdate("CREATE INDEX INDEXPSEUDO ON UTILISATEUR (PSEUDONYME)");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (statement != null) {
                    if (throwable != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        statement.close();
                    }
                }
            }
        }
        if (!this.verifierTable(connection, "MESSAGE")) {
            statement = connection.createStatement();
            throwable = null;
            try {
                statement.executeUpdate("CREATE TABLE MESSAGE (ID INTEGER, AUTEUR CHAR(30), DATECREATION TIMESTAMP, SUJET VARCHAR(255), TEXTE VARCHAR(4000))");
                statement.executeUpdate("CREATE INDEX INDEXDATE ON MESSAGE (DATECREATION)");
                statement.executeUpdate("CREATE INDEX INDEXID ON MESSAGE (ID)");
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (statement != null) {
                    if (throwable != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        statement.close();
                    }
                }
            }
        }
    }

    protected boolean verifierTable(Connection connection, String string) throws SQLException {
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        try (ResultSet resultSet = databaseMetaData.getTables(connection.getCatalog(), null, string, null);){
            boolean bl = resultSet.next();
            return bl;
        }
    }
}

