/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.forum;

import com.eteks.forum.AnalyseurXMLForum;
import com.eteks.forum.EnsembleMessagesForum;
import com.eteks.forum.MessageForum;
import com.eteks.forum.Utilisateur;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.util.Set;
import javax.swing.JApplet;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class AppletChat
extends JApplet {
    private JTextArea texteMessages = new JTextArea();
    private JScrollPane panneauAscenseur = new JScrollPane(this.texteMessages);
    private JLabel labelMessage = new JLabel("En cours de connexion...");
    private JTextField saisieMessage = new JTextField(50);
    private DateFormat formatHeure = DateFormat.getTimeInstance();
    private AnalyseurXMLForum analyseurXML = new AnalyseurXMLForum();
    private boolean arretApplet;

    @Override
    public void init() {
        this.texteMessages.setEditable(false);
        this.texteMessages.setLineWrap(true);
        this.texteMessages.setWrapStyleWord(true);
        JPanel panneauSaisie = new JPanel(new BorderLayout());
        panneauSaisie.add((Component)this.labelMessage, "West");
        panneauSaisie.add((Component)this.saisieMessage, "Center");
        this.saisieMessage.setVisible(false);
        this.setLayout(new BorderLayout(0, 5));
        this.add((Component)this.panneauAscenseur, "Center");
        this.add((Component)panneauSaisie, "South");
        this.saisieMessage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                String texteSaisi = AppletChat.this.saisieMessage.getText().trim();
                if (texteSaisi.length() > 0) {
                    AppletChat.this.envoyerMessage(texteSaisi);
                }
                AppletChat.this.saisieMessage.setText("");
            }
        });
    }

    public void afficherMessage(String message) {
        this.texteMessages.append(String.valueOf(message) + "\n");
        this.panneauAscenseur.getVerticalScrollBar().setValue(Integer.MAX_VALUE);
    }

    public void afficherErreur(String message) {
        this.labelMessage.setText(message);
        this.saisieMessage.setVisible(false);
        this.arretApplet = true;
    }

    public void annoncerArrivee() throws IOException {
        this.lancerRequete(this.getParameter("annoncerArrivee"));
    }

    public void lireParticipants() throws IOException {
        InputStream fluxLecture = this.connecter(this.getParameter("lireParticipants"));
        Set<Utilisateur> utilisateurs = this.analyseurXML.lireUtilisateursXML(fluxLecture);
        String message = "Participants du chat :";
        for (Utilisateur utilisateur : utilisateurs) {
            message = String.valueOf(message) + " " + utilisateur.getPseudonyme();
        }
        this.afficherMessage(message);
    }

    public void lireMessages() throws IOException {
        try {
            this.arretApplet = false;
            while (!this.arretApplet) {
                InputStream fluxLecture = this.connecter(this.getParameter("lireMessages"));
                this.afficherMessagesXML(fluxLecture);
                Thread.sleep(1000L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void afficherMessagesXML(InputStream fluxLecture) throws IOException {
        EnsembleMessagesForum messages = this.analyseurXML.lireMessagesXML(fluxLecture);
        for (MessageForum message : messages) {
            String messageAffiche = String.valueOf(this.formatHeure.format(message.getDateCreation())) + " - " + message.getAuteur() + " : " + message.getTexte();
            this.afficherMessage(messageAffiche);
        }
    }

    public void envoyerMessage(final String message) {
        Thread threadEnvoiMessage = new Thread(){

            @Override
            public void run() {
                try {
                    String ajouterMessageAvecTexte = String.valueOf(AppletChat.this.getParameter("ajouterMessage")) + "?texte=" + URLEncoder.encode(message, "ISO-8859-1");
                    AppletChat.this.lancerRequete(ajouterMessageAvecTexte);
                }
                catch (IOException ex) {
                    AppletChat.this.afficherErreur("Envoi du message impossible");
                }
            }
        };
        threadEnvoiMessage.start();
    }

    public void annoncerDepart() throws IOException {
        this.lancerRequete(this.getParameter("annoncerDepart"));
    }

    public void lancerRequete(String urlRelative) throws IOException {
        InputStream fluxLecture = this.connecter(urlRelative);
        fluxLecture.close();
    }

    public InputStream connecter(String urlRelative) throws IOException {
        URL url = new URL(this.getDocumentBase(), urlRelative);
        return url.openStream();
    }

    @Override
    public void start() {
        Thread threadApplet = new Thread(){

            @Override
            public void run() {
                try {
                    AppletChat.this.annoncerArrivee();
                    AppletChat.this.labelMessage.setText("Message : ");
                    AppletChat.this.saisieMessage.setVisible(true);
                    AppletChat.this.lireParticipants();
                    AppletChat.this.lireMessages();
                }
                catch (IOException ex) {
                    AppletChat.this.afficherErreur("Acc\u00e8s impossible au serveur");
                }
            }
        };
        threadApplet.start();
    }

    @Override
    public void stop() {
        this.arretApplet = true;
        try {
            this.annoncerDepart();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

