/*********************************************************************
   Danny Goodman's Audio Playback API JavaScript Library
   Copyright 2001 Danny Goodman (www.dannyg.com). All Rights Reserved.
   Excerpted from "JavaScript Bible" 4th Edition.
   
   v.1.0   First Release
   
   An Application Programming Interface for the following
   audio playback plug-ins and ActiveX objects:
     * Netscape LiveAudio(tm)
     * Microsoft Windows Media Player(tm) 6.0 or later
     * Apple QuickTime(tm) 4.1 or later
     
   Load this library into your HTML document with the 
   following HTML tags:
   
   <SCRIPT LANGUAGE="JavaScript" SRC="DGAudioAPI.js"></SCRIPT>
   
   Add the following event handler to your document's BODY tag:
   
      onLoad="initAudioAPI(['playerObjectID','MIMEType'])"
              
   ...where 'playerObjectID' is the identifier assigned to the
   ID attribute of the OBJECT or EMBED tag used to embed the
   player into the page; 'MIMEType' is the specific MIME type
   of the media to be loaded into the player object. Note that
   the parameters are strings, and are submitted as a literal
   array (inside square brackets). You can include multiple
   such arrays to initialize multiple objects, each with its
   own MIME type, if necessary.
   
   Your user interface controls can invoke the following API
   methods for basic audio playback control:
   
   Method             What It Does
   ---------------    -------------------------------------
   play(n)            Plays the currently loaded tune n times
   stop()             Stops the currently playing tune
   pause()            Pauses the currently playing tune
   rewind()           Rewinds the currently loaded tune to beginning
   
   load("URL")        Loads a new audio file into the player
   
   getVolume()        Returns volume integer (plug-in dependent range)
   setVolume(n)       Sets volume (n is integer from low to high range)
   
***********************************************************************/

// global variable declarations

// flag that gets set to false for incompatible browser
var OKToTest = true

// array of player objects to control (one object per OBJECT or EMBED)
var players = new Array()

// functions invoked from AudioAPI object methods

function API_play(n) {
	switch (this.type) {
		case "isLA" :
			document.embeds[this.id].play(n)
			break
		case "isQT" :
			document.embeds[this.id].Play()
			break
		case "isMP" :
			if (document.embeds[this.id]) {
				document.embeds[this.id].PlayCount = n
				document.embeds[this.id].Play()
			} else {
				if (document.all(this.id).HasError) {
					alert("MediaPlayer Alert: "  + document.all(this.id).ErrorDescription)
					break
				}
				document.all(this.id).PlayCount = n
				document.all(this.id).Play()
			}
			break
		default:
	}
}

function API_stop() {
	switch (this.type) {
		case "isLA" :
			document.embeds[this.id].stop()
			break
		case "isQT" :
			document.embeds[this.id].Stop()
			break
		case "isMP" :
			if (document.embeds[this.id]) {
				document.embeds[this.id].Stop()
			} else {
				document.all(this.id).Stop()
			}
			break
		default:
	}
}

function API_pause() {
	switch (this.type) {
		case "isLA" :
			document.embeds[this.id].pause()
			break
		case "isQT" :
			document.embeds[this.id].Stop()
			break
		case "isMP" :
			// Pause() method broken for IE5+
			if (document.embeds[this.id]) {
				document.embeds[this.id].Stop()
			} else {
				document.all(this.id).Stop()
			}
			break
		default:
	}
}

function API_rewind() {
	switch (this.type) {
		case "isLA" :
			document.embeds[this.id].stop()
			document.embeds[this.id].start_at_beginning()
			break
		case "isQT" :
			document.embeds[this.id].Stop()
			document.embeds[this.id].Rewind()
			break
		case "isMP" :
			if (document.embeds[this.id]) {
				document.embeds[this.id].Stop()
				document.embeds[this.id].CurrentPosition = 0
			} else {
				document.all(this.id).Stop()
				document.all(this.id).CurrentPosition = 0
			}
			break
		default:
	}
}

function API_load(URL) {
	switch (this.type) {
		case "isLA" :
			document.embeds[this.id].play(1, URL)
			setTimeout("document.embeds['" + this.id + "'].stop()",2000)
			break
		case "isQT" :
			document.embeds[this.id].SetURL(URL)
			setTimeout("document.embeds['" + this.id + "'].Stop()",2000)
			break
		case "isMP" :
			if (document.embeds[this.id]) {
				document.embeds[this.id].Open(URL)
			} else {
				document.all(this.id).Open(URL)
			}
			break
		default:
	}
}

function API_getVolume() {
	switch (this.type) {
		case "isLA" :
			return document.embeds[this.id].GetVolume()
			break
		case "isQT" :
			return document.embeds[this.id].GetVolume()
			break
		case "isMP" :
			if (document.embeds[this.id]) {
				return document.embeds[this.id].Volume
			} else {
				return document.all(this.id).Volume
			}
			break
		default:
	}
}

function API_setVolume(n) {
	switch (this.type) {
		case "isLA" :
			document.embeds[this.id].setvol(n)
			break
		case "isQT" :
			document.embeds[this.id].SetVolume(n)
			break
		case "isMP" :
			if (document.embeds[this.id]) {
				document.embeds[this.id].Volume = n
			} else {
				document.all(this.id).Volume = n
			}
			break
		default:
	}
}

// AudioAPI object constructor
function API(id, mime) {
	this.id = id
	this.type = ""  // values can be "isLA","isMP","isQT"
	this.mimeType = mime
	this.play = API_play
	this.stop = API_stop
	this.pause = API_pause
	this.rewind = API_rewind
	this.load = API_load
	this.getVolume = API_getVolume
	this.setVolume = API_setVolume
}

function initAudioAPI() {
	var args = initAudioAPI.arguments
	var id, mime
	for (var i = 0; i < args.length; i++) {
		// don't init any more if browser lacks scriptable sound
		if (OKToTest) {
			id = args[i][0]
			mime = args[i][1]
			players[id] = new API(id, mime)
			players[id].type = setType(id, mime)
		}
	}
	
}

// BEGIN SUPPORT FUNCTIONS

function setType(id, mime) {
	var type = ""
	var errMsg = "This browser is not equipped for scripted sound.\n\n"
	var OS = getOS()
	var brand = getBrand()
	var ver = getVersion(brand)
	if (brand == "IE") {
		if (ver > 4) {
			if (document.all(id) && document.all(id).HasError) {
				errMsg = document.all(id).ErrorDescription
			} else {
				if (OS == "Win") {
					if (document.all(id) && document.all(id).CreationDate != "") {
						return "isMP"
					} else {
						errMsg += "Expecting Windows Media Player Version 6.4."
					}
				} else {
					errMsg += "Only Internet Explorer for Windows is supported."
				}
			}
		} else { 
			errMsg += "Only Internet Explorer 4 or later for Windows is supported."
		}
	} else if (brand == "NN") {
		if ((ver >= 3 && ver < 4.6) || (ver >= 4.7 && ver < 6)) {
			if (mimeAndPluginReady(mime, "LiveAudio")) {
				return "isLA"
			}
			if (mimeAndPluginReady(mime, "QuickTime")) {
				qtVer = parseFloat(document.embeds[id].GetPluginVersion(), 10)
				if (qtVer >= 4.1) {
					return "isQT"
				} else {
					errMsg += "QuickTime Plugin 4.1 or later is required."
				}
			} else {
				errMsg += "Sound control requires QuickTime Plugin 4.1 (or later) or LiveAudio "
				errMsg += "enabled for MIME type: \'" + mime + "\'."
			}
		} else {
			errMsg += "Requires Navigator 3.x, 4.0-4.5, or 4.7-4.9."
		}
	} else {
		errMsg += "This page is certified only for versions of Internet Explorer "
		errMsg == "and Netscape Navigator."
	}
	alert(errMsg)
	OKToTest = false
	return type
}

function getOS() {
	var ua = navigator.userAgent
	if (ua.indexOf("Win") != -1) {
		return "Win"
	}
	if (ua.indexOf("Mac") != -1) {
		return "Mac"
	}
	return "Other"
}

function getBrand() {
	var name = navigator.appName
	if (name == "Netscape") {
		return "NN"
	}
	if (name.indexOf("Internet Explorer") != -1) {
		return "IE"
	}
	return "Other"
}

function getVersion(brand) {
	var ver = navigator.appVersion
	var ua = navigator.userAgent
	if (brand == "NN") {
		if (parseInt(ver, 10) < 5) {
			return parseFloat(ver, 10)
		} else {
			return parseFloat(ua.substring(ua.lastIndexOf("/")+1))
		}
	}
	if (brand == "IE") {
		var IEOffset = ua.indexOf("MSIE ")
		return parseFloat(ua.substring(IEOffset + 5, ua.indexOf(";", IEOffset)))
	}
	return 0
}

// Pass "<type>/<subtype>" string to this function to find
// out if the MIME type is registered with this browser
// and that at least some plug-in is enabled for that type.
function mimeIsReady(mime_type) {
	if (navigator.mimeTypes[mime_type]) {
		if (navigator.mimeTypes[mime_type].enabledPlugin) {
			return true
		}
	}
	return false
}

// Pass "<type>/<subtype>" and plug-in name strings for this
// function to see if both the MIME type and plug-in are
// registered with this browser, and that the plug-in is
// enabled for the desired MIME type.
function mimeAndPluginReady(mime_type,plug_in) {
	if (mimeIsReady(mime_type)) {
		var plugInOfRecord = navigator.mimeTypes[mime_type].enabledPlugin
		plug_in = plug_in.toLowerCase()
		for (var i = 0; i < navigator.plugins.length; i++) {
			if (navigator.plugins[i].name.toLowerCase().indexOf(plug_in) != -1) {
				if (navigator.plugins[i] == plugInOfRecord) {
					return true
				}
			}
		}
	}
	return false
}
