/* Simple clock applet demonstrating access from JavaScript
   by Danny Goodman  (http://www.dannyg.com)
*/

import java.awt.*;
import java.util.Date;

public class ScriptableClock extends java.applet.Applet implements Runnable {
	
	// control variables
	final boolean GMT = true;
	final boolean LOCALE = false;
	String displayDate;
	Font displayFont;
	Thread thread;
	
	// parameter options
	Color bgColor;
	Color fgColor;
	Rectangle displayArea;
	String fontName;
	int fontSize;
	int fontStyle;
	int height, width;
	boolean timeZone;
	
	public void init() {
		parseArgs();
		displayFont = new Font(fontName, fontStyle, fontSize);
		timeZone = LOCALE;
		displayArea = bounds();
		height = displayArea.height;
		width = displayArea.width;
		resize(width,height);	
	}
	
	public void start() {
		if(thread == null) {
			thread = new Thread(this);
			thread.start();	
		}
	}
	
	public void stop() {
		if(thread != null) {
			thread.stop();
			thread = null;
		}
	}
	
	public void run() {
		while(thread != null) {
			Date theDate = new Date();
			displayDate = (timeZone) ? theDate.toGMTString() : theDate.toLocaleString();
			repaint();
			try {
				Thread.sleep(1000);	
			}
			catch(InterruptedException e)  {}
		}
	}
	
	public void paint(Graphics g) {
		g.setColor(bgColor);
		g.fillRect(0,0,width,height);
		
		g.setColor(fgColor);
		g.setFont(displayFont);
		
		FontMetrics fm = getFontMetrics(getFont());
		int textWidth = fm.stringWidth(displayDate);
		int horizOffset = (width / 2) - (textWidth / 2);
		g.drawString(displayDate,5,35);
	}
	
	
	/*
	      Begin public methods for getting
	      and setting data via LiveConnect
	*/
	public void setTimeZone(String zone) {
		stop();
		timeZone = (zone.startsWith("GMT")) ? true : false;
		start();
	}
	
	public void setFont(String newFont, String newStyle, String newSize) {
		stop();
		if (newFont != null && newFont != "") 
			fontName = newFont;
		if (newStyle != null && newStyle != "")
			setFontStyle(newStyle);
		if (newSize != null && newSize != "")
			setFontSize(newSize);
		displayFont = new Font(fontName, fontStyle, fontSize);
		start();
	}
	
	public void setColor(String newbgColor, String newfgColor) {
		stop();
		bgColor = parseColor(newbgColor);
		fgColor = parseColor(newfgColor);
		start();
	}
	
	public String getInfo() {
		String result = "Info about ScriptableClock.class\r\n";
		result += "Version/Date: 1.0d1/2 May 1996\r\n";
		result += "Author: Danny Goodman (dannyg@dannyg.com)\r\n";
		result += "Public Variables:\r\n";
		result += "   (None)\r\n\r\n";
		result += "Public Methods:\r\n";
		result += "   setTimeZone(\"GMT\" | \"Locale\")\r\n";
		result += "   setFont(\"fontName\",\"Plain\" |\"Bold\" | \"Italic\", \"fontSize\")\r\n";
		result += "   setColor(\"bgColorName\", \"fgColorName\")\r\n";
		result += "       colors: Black, White, Red, Green, Blue, Yellow\r\n";
		return result;
	}
	/*
		End public methods for scripted access.
	*/
	
	
	private void setFontStyle(String style) {
		try {
			if(style.equalsIgnoreCase("Plain"))
				fontStyle = Font.PLAIN;
			else if(style.equalsIgnoreCase("Italic"))
				fontStyle = Font.ITALIC;
			else
				fontStyle = Font.BOLD;
		}
		catch(Exception e) {
			fontStyle = Font.BOLD;
		}
	}
	
	private void setFontSize(String size) {
		try {
			fontSize = Integer.parseInt(size);
		}
		catch(Exception e) {
			fontSize = 24;
		}
	}
	
	private void parseArgs() {
		fontName = getParameter("font");
		if (fontName == null) {
			fontName = new String("TimesRoman");
		}
		
		String n = getParameter("fontSize");
		setFontSize(n);
				
		n = getParameter("fontStyle");
		setFontStyle(n);
		
		bgColor = parseColor(getParameter("bgColor"));
		if(bgColor == null)
			bgColor = Color.white;
		
		fgColor = parseColor(getParameter("fgColor"));
		if(fgColor == null)
			fgColor = Color.black;
	}

	private Color parseColor(String c) {
		try {
			if (c.equalsIgnoreCase("Black"))
				return Color.black;
			else if (c.equalsIgnoreCase("White"))
				return Color.white;
			else if (c.equalsIgnoreCase("Red"))
				return Color.red;
			else if (c.equalsIgnoreCase("Green"))
				return Color.green;
			else if (c.equalsIgnoreCase("Blue"))
				return Color.blue;
			else if (c.equalsIgnoreCase("Yellow"))
				return Color.yellow;
			else
				return Color.black;
		}
		catch (Exception e) {
			return null;	
		}
	}
}
