
-- Bind

VARIABLE g_nom VARCHAR2(25)
BEGIN
 :g_nom := 'LARRAZET';
 END;
/

SET AUTOTRACE ON
SELECT prenom,tel FROM Adherentbis WHERE nom = :g_nom 
       AND civilite = 'Mme.' AND tel LIKE '+1-%';
EXECUTE :g_nom := 'DURAND'
SELECT prenom,tel FROM Adherentbis WHERE nom = :g_nom 
       AND civilite = 'Mme.' AND tel LIKE '+1-%';
SET AUTOTRACE OFF


--PL/SQL

SET SERVEROUT ON

DECLARE
 v_nom Adherentbis.nom%TYPE;
 v_p   Adherentbis.prenom%TYPE;
 v_t   Adherentbis.tel%TYPE;
BEGIN
 v_nom := 'LARRAZET';
 SELECT prenom,tel INTO v_p, v_t FROM Adherentbis WHERE nom = v_nom 
       AND civilite = 'Mme.' AND tel LIKE '+1-%';
 DBMS_OUTPUT.PUT_LINE(v_p || v_t);
 END;
/

--SQL dynamique

DECLARE
 v_nom Adherentbis.nom%TYPE;
 v_p   Adherentbis.prenom%TYPE;
 v_t   Adherentbis.tel%TYPE;
BEGIN
 v_nom := 'LARRAZET';
 EXECUTE IMMEDIATE
  'SELECT prenom,tel FROM Adherentbis WHERE nom = :v_nom 
       AND civilite = ''Mme.'' AND tel LIKE ''+1-%'' ' 
 INTO v_p,v_t USING v_nom;
 DBMS_OUTPUT.PUT_LINE(v_p || v_t);
 END;
/

--Comparaisons

ALTER SYSTEM FLUSH SHARED_POOL;
SET SERVEROUTPUT ON;

DECLARE
      TYPE RC IS REF CURSOR;
      L_RC RC;
      L_DUMMY ALL_OBJECTS.OBJECT_NAME%TYPE;
      L_START NUMBER DEFAULT DBMS_UTILITY.GET_TIME;
BEGIN
      FOR i IN 1 .. 50000
      LOOP
        OPEN L_RC FOR 'SELECT nom FROM Adherentbis WHERE adhid = ' || i;
        BEGIN
          FETCH L_RC INTO L_DUMMY;
        EXCEPTION
          WHEN NO_DATA_FOUND THEN NULL;
        END;
        CLOSE L_RC;
      --  DBMS_OUTPUT.PUT_LINE(L_DUMMY);
      END LOOP;
      DBMS_OUTPUT.PUT_LINE
       (ROUND((DBMS_UTILITY.GET_TIME-L_START)/100, 2) || ' SECONDS...' );
END;
/

DECLARE
      TYPE RC IS REF CURSOR;
      L_RC RC;
      L_DUMMY ALL_OBJECTS.OBJECT_NAME%TYPE;
      L_START NUMBER DEFAULT DBMS_UTILITY.GET_TIME;
BEGIN
      FOR i IN 1 .. 50000
      LOOP
        OPEN L_RC FOR 'SELECT nom FROM Adherentbis WHERE adhid = :v_ad' USING i;
        BEGIN
          FETCH L_RC INTO L_DUMMY;
        EXCEPTION
          WHEN NO_DATA_FOUND THEN NULL;
        END;
        CLOSE L_RC;
      --  DBMS_OUTPUT.PUT_LINE(L_DUMMY);
      END LOOP;
      DBMS_OUTPUT.PUT_LINE
       (ROUND((DBMS_UTILITY.GET_TIME-L_START)/100, 2) || ' SECONDS...' );
END;
/
