
-- vues matrialises

CREATE MATERIALIZED VIEW adh_escrime_pingpong
     TABLESPACE tbs_cluster
     BUILD IMMEDIATE
     REFRESH COMPLETE
     ENABLE QUERY REWRITE
     AS SELECT  a.adhid, s.spid, s.splibelle, a.nom, a.prenom,
                a.tel, a.date_nais, a.solde
        FROM  Adherentbis a, Sport s, Pratiquebis p
        WHERE s.splibelle  IN ('Escrime','Ping-pong')
        AND   a.adhid = p.adhid
        AND   s.spid  = p.spid
        ORDER BY a.adhid,a.nom;

CREATE INDEX adh_escrime_pingpong_nom_idx 
     ON adh_escrime_pingpong(nom)
     TABLESPACE tbs_index;

-- collecte des stats

EXECUTE DBMS_STATS.GATHER_SCHEMA_STATS(ownname=>'SOUTOU',cascade=>true);

SET TIMING ON

SET AUTOTRACE TRACEONLY
SELECT  /*+ NO_REWRITE */ a.adhid, a.nom, a.tel
    FROM  Adherentbis a, Sport s, Pratiquebis p
    WHERE s.splibelle  = 'Escrime'
    AND   a.adhid = p.adhid
    AND   s.spid  = p.spid;
--
SELECT  a.adhid, a.nom, a.tel
    FROM  Adherentbis a, Sport s, Pratiquebis p
    WHERE s.splibelle  = 'Escrime'
    AND   a.adhid = p.adhid
    AND   s.spid  = p.spid;
SET AUTOTRACE OFF

SET AUTOTRACE TRACEONLY
SELECT  a.adhid, a.nom, a.tel
    FROM  Adherentbis a, Sport s, Pratiquebis p
    WHERE s.splibelle  = 'Escrime'
    AND   a.adhid = p.adhid
    AND   s.spid  = p.spid;
--
SELECT  a.adhid, a.nom, a.tel
    FROM  Adherentbis a, Sport s, Pratiquebis p
    WHERE s.splibelle  = 'Ping-pong'
    AND   a.adhid = p.adhid
    AND   s.spid  = p.spid;
--
SELECT  a.adhid, a.nom, a.tel
    FROM  Adherentbis a, Sport s, Pratiquebis p
    WHERE s.splibelle  = 'Golf'
    AND   a.adhid = p.adhid
    AND   s.spid  = p.spid;
SET AUTOTRACE OFF

SET TIMING OFF

CREATE MATERIALIZED VIEW LOG ON Sport WITH PRIMARY KEY, ROWID; 

CREATE MATERIALIZED VIEW catalogue_sports 
   REFRESH FAST ON COMMIT
   WITH PRIMARY KEY 
   AS   SELECT spid, splibelle FROM  Sport; 

CREATE MATERIALIZED VIEW LOG ON Adherentbis 
    WITH PRIMARY KEY, ROWID
    PURGE REPEAT INTERVAL '5' DAY;

CREATE MATERIALIZED VIEW Adherent_hommes
   REFRESH FAST 
   START WITH ROUND(SYSDATE + 1) + 11/24 
   NEXT NEXT_DAY(TRUNC(SYSDATE),'LUNDI') + 15/24
   WITH PRIMARY KEY 
   AS   SELECT a.adhid, a.nom, a.prenom, a.tel, a.date_nais, a.solde
        FROM  Adherentbis a
        WHERE a.civilite = 'Mr.';