--- Fonctions
--caractres

CREATE TABLE Pilote
	(brevet VARCHAR(6) CONSTRAINT pk_Pilote PRIMARY KEY,
	 prenom VARCHAR(10), nom VARCHAR(10), surnom VARCHAR(10), compa VARCHAR(4));

INSERT INTO Pilote VALUES ('PL-1', 'Gratien', 'viel',  'dba', 'AF');
INSERT INTO Pilote VALUES ('PL-2', 'Didier', 'donsez',  'smith', 'AF');
INSERT INTO Pilote VALUES ('PL-3', 'richard', 'Grin', 'Faucon', 'SING');
INSERT INTO Pilote VALUES ('PL-4', 'placide', 'Fresnais','cool', 'CAST');
INSERT INTO Pilote VALUES ('PL-5', 'Daniel', 'vielle', 'jone', 'SING');
INSERT INTO Pilote VALUES ('PL-6', 'Francoise', 'tort', 'NormaleSup', 'CAST');


SELECT ASCII('A') FROM DUAL;
SELECT CONCAT( CONCAT(nom, ' travaille pour '), compa) "Personnel" 
      FROM Pilote;
SELECT INITCAP(prenom) "Prnom", INITCAP(nom) "Nom" FROM Pilote WHERE compa = 'SING';

--2eme Air aprs le 9eme caractres
SELECT INSTR('Infos-Air : AirBus pour Air-France','Air', 9, 2) "Indice" FROM DUAL;
 

SELECT LOWER(prenom) || ' ' || LOWER(nom) "Etat civil" FROM Pilote WHERE compa = 'SING';

SELECT LENGTH('Infos-Air : AirBus pour Air-France') "Taille" FROM DUAL;
 

SELECT LPAD('Rien',20,'-.-') "sur 20" FROM DUAL;


SELECT LTRIM('B747B747A380  Blagnac','B747') "Bye les Jumbo" FROM DUAL;

SELECT REPLACE('Matra et Aerospatiale','Matra','EADS') "Changement"
         FROM DUAL;

SELECT RPAD('Rien',19,'-.-') "sur 19" FROM DUAL;


SELECT RTRIM('A380  BlagnacB747B747','B747') "Bye les Jumbo" FROM DUAL;


SELECT nom, surnom, compa FROM Pilote
          WHERE SOUNDEX(surnom) IN ( SOUNDEX('SMYTHE'), SOUNDEX('John'));

SELECT SUBSTR('Air France  Blagnac Con!',12,9) "O a?"
     FROM DUAL;
 
SELECT TRANSLATE('ORACLE9i',
'0123456789ABCDEFGHIJKLMNOPQR', 
'ChaineVers-Codage-0123456789') "Codage" FROM DUAL;

SELECT TRIM('B' FROM 'BA380  BlagnacBBBBB') "Bye les Jumbo" FROM DUAL;

SELECT UPPER(prenom) || ' ' || UPPER(nom) "Pilotes de CAST" FROM Pilote WHERE compa = 'CAST';

DROP TABLE Pilote;

--dates
 
SELECT ADD_MONTHS(SYSDATE,4) "RDV" FROM DUAL;
SELECT CURRENT_DATE, SYSDATE FROM DUAL;
SELECT LAST_DAY(SYSDATE) FROM DUAL;
SELECT NEXT_DAY(SYSDATE,'LUNDI') "Mardi" FROM DUAL;
SELECT MONTHS_BETWEEN('05-02-65',SYSDATE) FROM DUAL;
SELECT TRUNC(SYSDATE, 'MONTH') FROM DUAL;
SELECT EXTRACT(MONTH FROM (SYSDATE-65)) "Mois" FROM DUAL;
SELECT NEXT_DAY(SYSDATE,'MERCREDI') "Mercr/7" FROM DUAL;
SELECT NEXT_DAY(SYSDATE,'MERCREDI') "Jeudi/7" FROM DUAL;
SELECT ROUND(TO_DATE('28-OCT-2005'),'MONTH') "Arrondi" FROM DUAL;
SELECT TRUNC(TO_DATE('28-OCT-2005'),'MONTH') "Tronque" FROM DUAL;

--

SELECT GREATEST('Raffarin','Chirac','X-Men') FROM DUAL;
SELECT LEAST('Raffarin','Chirac','X-Men') FROM DUAL;
SELECT NULLIF('Raffarine','Parafine') FROM DUAL;

--GROUPES

CREATE TABLE Pilote
	(brevet VARCHAR(6) CONSTRAINT pk_Pilote PRIMARY KEY,
	 nom VARCHAR(16), nbHVol NUMBER(7,2), prime NUMBER(4), embauche DATE, typeAvion CHAR(4), compa VARCHAR(4));

INSERT INTO Pilote VALUES ('PL-1', 'Gratien Viel', 450, 500, '05-02-1965 ','A320', 'AF');
INSERT INTO Pilote VALUES ('PL-2', 'Didier Donsez',  0, NULL, '13-05-1995', 'A320',    'AF');
INSERT INTO Pilote VALUES ('PL-3', 'Richard Grin',  1000, NULL, '11-09-2001', 'A320', 'SING');
INSERT INTO Pilote VALUES ('PL-4', 'Placide Fresnais',2450, 500,'21-09-2001', 'A330', 'SING');
INSERT INTO Pilote VALUES ('PL-5', 'Daniel Vielle',    400, 600, '16-01-1965', 'A340', 'AF');
INSERT INTO Pilote VALUES ('PL-6', 'Francoise Tort', NULL, 0, '24-12-2000', 'A340', 'CAST');


SELECT nbHVol FROM Pilote WHERE compa = 'AF';
SELECT AVG(nbHVol), AVG(prime) FROM Pilote WHERE compa = 'AF';
SELECT AVG(NVL(nbHVol,0)) FROM Pilote WHERE compa = 'AF';
SELECT  COUNT(*), COUNT(nbHVol), COUNT(prime), COUNT(DISTINCT prime) FROM Pilote;
SELECT MAX(nbHVol), MAX(embauche) "Date+", MIN(prime), MIN(embauche) "Date-" FROM Pilote;
SELECT STDDEV(prime), SUM(nbHVol), VARIANCE(prime) FROM Pilote WHERE compa = 'AF';

--
SELECT compa, AVG(nbHVol), AVG(prime) FROM Pilote GROUP BY(compa);
SELECT  compa, COUNT(*), COUNT(nbHVol) FROM Pilote GROUP BY(compa);
SELECT compa, MAX(nbHVol), MAX(embauche) "Date+" FROM Pilote GROUP BY(compa);
SELECT compa,STDDEV(prime), SUM(nbHVol) FROM Pilote WHERE typeAvion = 'A320' GROUP BY(compa);
SELECT  compa, typeAvion, COUNT(brevet) FROM Pilote GROUP BY(compa,typeAvion);
SELECT compa,COUNT(brevet) FROM Pilote GROUP BY(compa) HAVING COUNT(brevet)>=2;

DROP TABLE Pilote;




