
DROP TABLE Test ;
CREATE TABLE Test (col VARCHAR2(10));

INSERT INTO Test VALUES ('bonjour');
INSERT INTO Test VALUES ('enfant');
INSERT INTO Test VALUES ('matre');
INSERT INTO Test VALUES ('mbile');
INSERT INTO Test VALUES ('Matre');
INSERT INTO Test VALUES ('pjaro');
INSERT INTO Test VALUES ('zurck');


--

SQL> SELECT col FROM Test WHERE REGEXP_LIKE(col,'([[:lower:]]){6}');

SQL> SELECT col FROM Test WHERE REGEXP_LIKE(col,'^[[:lower:]]{6}$');


SQL> SELECT col FROM Test WHERE REGEXP_LIKE(col,'^[[:upper:]]{1}[[:lower:]]{5}$');


DROP TABLE Test ;
CREATE TABLE Test (col VARCHAR2(10));

INSERT INTO Test VALUES ('resume');
INSERT INTO Test VALUES ('rsum');
INSERT INTO Test VALUES ('rsume');
INSERT INTO Test VALUES ('resum');
INSERT INTO Test VALUES ('rasum');
INSERT INTO Test VALUES ('rsume');


SELECT col FROM test WHERE REGEXP_LIKE(col,'r[[=e=]]sum[[=e=]]');


SELECT col FROM test WHERE REGEXP_LIKE(col,'r[[=a=]]sum[[=e=]]');

---


DROP TABLE Test ;
CREATE TABLE Test (col VARCHAR2(30));

INSERT INTO Test VALUES ('Leo JeanJean');
INSERT INTO Test VALUES ('Peter Grenberg');
INSERT INTO Test VALUES ('John Woo');
INSERT INTO Test VALUES ('Maurice Greene');
INSERT INTO Test VALUES ('Bruce LEE');
INSERT INTO Test VALUES ('Paul Soutouuu');

SELECT col FROM Test
	WHERE NOT REGEXP_LIKE(col, '([aeiou])\1', 'i');

SELECT col FROM Test
	WHERE REGEXP_LIKE(col, '([aeiou])\1', 'i');

SELECT col FROM Test
	WHERE REGEXP_LIKE(col, '^(.*)\1$', 'i');

SELECT col FROM Test
	WHERE REGEXP_LIKE(col, '(.*)\1', 'i');


DROP TABLE Test ;

-------------
SET ECHO ON

DROP TABLE Parcs ;

CREATE TABLE Parcs (endroit VARCHAR2(7),telephone VARCHAR2(15),description VARCHAR2(400));

INSERT INTO Parcs VALUES ('P1', '(231) 436-4100',
    'Michigan''s first state park encompasses approximately 1800 acres
of Mackinac Island. The centerpiece is Fort Mackinac, built in 1780 by
the British to protect the Great Lakes Fur Trade. For information by
phone, dial 800-44-PARKS or 517-373-1214.');

INSERT INTO Parcs VALUES ('P2', '(906) 289-4215',
    'Located almost at the very tip of the Keewenaw Penninsula,
Fort Wilkens is a restored army fort built during the copper rush.
Camping is available. For the modern campground, phone (800) 447-2757. For
group-camping, phone 906.289.4215. For information on canoe, kayak, and
other boat rentals, call the concession office at (906) 289-4210.');

INSERT INTO Parcs VALUES ('P3', '(906) 863-9747', 'This scenic site is centered around an impressive waterfall.
A rustic, picnic area with waterpump is available.');

INSERT INTO Parcs VALUES ('P4', '(906) 658-3338',
    'A 217-acre park located on the site of an old lumber town, Deer Park.
Shower and toilet facilities are available, as are campsites with
electricity.');

INSERT INTO Parcs VALUES ('P5', '(906) 885-5275',
    'Michigan''s largest state park consists of some 60,000 acres
of mostly virgin timber. Over 90 miles of trails are available
to backpackers and hikers. Downhill skiing is available in winter.
Rustic cabins are available. To reserve a cabin, call (906) 885-5275.');

INSERT INTO Parcs VALUES ('P6',  NULL, 
'One of the largest waterfalls east of the Mississippi is found
within this park''s 40,000+ acres. Upper Tahquamenon Falls is some 50 feet
high, 200 feet across, and supports a flow that has been known to reach
50,000 gallons/second. The park phone is 906.492.3415.');


COMMIT;
SELECT * FROM Parcs ;

SELECT endroit FROM Parcs WHERE REGEXP_LIKE(description, '...-....');

SELECT endroit FROM Parcs 
	WHERE REGEXP_LIKE(description, '[0-9][0-9][0-9]-[0-9][0-9][0-9][0-9]');

SELECT endroit FROM Parcs 
	WHERE REGEXP_LIKE(description, '[0-9]{3}-[0-9]{4,4}');

SELECT endroit FROM Parcs 
	WHERE REGEXP_LIKE(description, '[0-9]{3}[-.][0-9]{4,4}');


------------------------

ALTER TABLE Parcs 
ADD (CONSTRAINT ck_format_telephone
     CHECK (REGEXP_LIKE(telephone,
     '^\([[:digit:]]{3}\) [[:digit:]]{3}-[[:digit:]]{4}$')));

INSERT INTO Parcs (endroit , telephone)
   VALUES ('P7','616.426.4013');

INSERT INTO Parcs (endroit , telephone)
   VALUES ('P8','(616) 426-4013 ');

INSERT INTO Parcs (endroit , telephone)
   VALUES ('P9',' (616) 426-4013');

INSERT INTO Parcs (endroit , telephone)
   VALUES ('P10','(616) 426-4013');


-------REGEXP_REPLACE

SELECT endroit,description  FROM Parcs WHERE endroit = 'P1';

SELECT endroit, description FROM Parcs ;

COL remplacement FORMAT A200 HEADING "REGEXP_REPLACE"
SELECT endroit,REGEXP_REPLACE(description,
   '([[:digit:]]{3})[-.]([[:digit:]]{3})[-.]([[:digit:]]{4})','(\1) \2-\3')  remplacement 
  FROM Parcs WHERE endroit = 'P1';


--Following is the UPDATE statement:
UPDATE Parcs
SET description = REGEXP_REPLACE(description,
    '([[:digit:]]{3})[-.]([[:digit:]]{3})[-.]([[:digit:]]{4})',
    '(\1) \2-\3');

SELECT endroit , description
FROM Parcs ;

--puts a space after each non-null character in the string

DROP TABLE Test ;
CREATE TABLE Test (col VARCHAR2(30));

INSERT INTO Test VALUES ('Castanet');
INSERT INTO Test VALUES ('Blagnac');
INSERT INTO Test VALUES ('Paris');

COL remplacement FORMAT A20 HEADING "REGEXP_REPLACE"
SELECT REGEXP_REPLACE(col, '(.)', '\1-') remplacement FROM Test ;

SELECT REGEXP_REPLACE(col, '(.)', '\1-') FROM Test ;


DROP TABLE Test ;


looking for two or more spaces. 
Oracle replaces each occurrence of two or more spaces with a single space.

SELECT REGEXP_REPLACE('IUT,    1    Place  G.    Brassens,  Blagnac',
 '( ){2,}', ' ') "Exemple 2" FROM DUAL;


-------REGEXP_INSTR 


SELECT REGEXP_INSTR('IUT Dept GTR, 31703 Blagnac',
               '[^ ]+', 1, 4) "Exemple 1" FROM DUAL;

SELECT REGEXP_INSTR('500 Oracle Parkway, Redwood Shores, CA',
               '[s|r|p][[:alpha:]]{6}', 3, 2, 1, 'i') "Exemple 2"
  FROM DUAL;


COLUMN endroit  format a8
COLUMN surface format a13

SELECT endroit , SUBSTR(description,
    REGEXP_INSTR(description, '[^ ]+ acres|[^ ]+-acre',1,1,0,'i'),
    REGEXP_INSTR(description, '[^ ]+ acres|[^ ]+-acre',1,1,1,'i')
    - REGEXP_INSTR(description, '[^ ]+ acres|[^ ]+-acre',1,1,0,'i')) surface 
FROM Parcs
WHERE REGEXP_LIKE(description, '[^ ]+ acres|[^ ]+-acre','i');


-- REGEXP_SUBSTR -

SELECT REGEXP_SUBSTR('IUT Dept GTR, 31703 Blagnac',
               '[^ ]+', 1, 4) "Ex. 1" FROM DUAL;


SELECT REGEXP_SUBSTR('500 Oracle Parkway, Redwood Shores, CA',
               '[s|r|p][[:alpha:]]{6}', 1, 2, 'i') "Ex. 2"
  FROM DUAL;

COLUMN endroit  format a8
COLUMN surface format a13 heading "Ex. 3"
SELECT endroit,
       REGEXP_SUBSTR(description,'[^ ]+[- ]acres?',1,1,'i') surface 
	FROM Parcs WHERE REGEXP_LIKE(description, '[^ ]+[- ]acres?','i');





