
-- Cration des tablespaces

--sous SYSTEM

CREATE TABLESPACE tbs_index 
   DATAFILE 'tbs_index.dat' SIZE 500M REUSE
   AUTOEXTEND ON NEXT 500K MAXSIZE 2000M;

CREATE TABLESPACE tbs_cluster
   DATAFILE 'tbs_cluster.dat' SIZE 1000M REUSE
   AUTOEXTEND ON NEXT 500K MAXSIZE 9000M;

CREATE TABLESPACE tbs_part1
   DATAFILE 'tbs_part1.dat' SIZE 100M REUSE
   AUTOEXTEND ON NEXT 500K MAXSIZE 4000M;
CREATE TABLESPACE tbs_part2
   DATAFILE 'tbs_part2.dat' SIZE 100M REUSE
   AUTOEXTEND ON NEXT 500K MAXSIZE 4000M;
CREATE TABLESPACE tbs_part3
   DATAFILE 'tbs_part3.dat' SIZE 100M REUSE
   AUTOEXTEND ON NEXT 500K MAXSIZE 4000M;
CREATE TABLESPACE tbs_part4
   DATAFILE 'tbs_part4.dat' SIZE 100M REUSE
   AUTOEXTEND ON NEXT 500K MAXSIZE 4000M;

-- modifiez "soutou" par votre nom de user

GRANT UNLIMITED TABLESPACE TO soutou;

-- sous votre user :

CREATE TABLE Sport
 (spid NUMBER(5) NOT NULL, splibelle VARCHAR(20) NOT NULL);

CREATE TABLE Adherent 
 (adhid      NUMBER(5) NOT NULL, 
  nom        VARCHAR(25) NOT NULL, 
  prenom     VARCHAR(30) NOT NULL, 
  civilite   VARCHAR(12) NOT NULL, 
  date_nais  DATE NOT NULL,
  tel        VARCHAR(15));

CREATE TABLE Pratique
  (adhid NUMBER(5) NOT NULL, spid NUMBER(5) NOT NULL);

-- insertion des donnes 
-- modifiez "temp" par le chemin de votre rpertoire (pas d'espaces dans les noms...)

SET ECHO OFF

start C:\temp\Chap14-2-insertions-base-sports.sql
COMMIT;

SET ECHO ON

-- initialisation des soldes

ALTER TABLE Adherent 
      ADD solde NUMBER(8,2);
UPDATE Adherent 
       SET solde = (SELECT ROUND(ABS(DBMS_RANDOM.VALUE(0,30000)),2) FROM DUAL);
COMMIT;

-- des tlphones distincts pour tout le monde (ou des valeurs NULL)

UPDATE Adherent 
   SET tel= 
   TO_CHAR(ABS(MOD(DBMS_RANDOM.RANDOM,9))||ABS(MOD(DBMS_RANDOM.RANDOM,9))
     ||'-'|| ABS(MOD(DBMS_RANDOM.RANDOM,9))||ABS(MOD(DBMS_RANDOM.RANDOM,9))
     ||'-'|| ABS(MOD(DBMS_RANDOM.RANDOM,9))||ABS(MOD(DBMS_RANDOM.RANDOM,9))
     ||'-'|| ABS(MOD(DBMS_RANDOM.RANDOM,9))||ABS(MOD(DBMS_RANDOM.RANDOM,9))
     ||'-'|| ABS(MOD(DBMS_RANDOM.RANDOM,9))||ABS(MOD(DBMS_RANDOM.RANDOM,9)))
   WHERE tel IS NOT NULL;
COMMIT;

--------------------------------------------------
--s'assurer de l'unicit

SELECT COUNT(adhid) 
       FROM Adherent WHERE tel IS NULL;

-->  765 Adhrents ont le tel  NULL, c'est OK

SELECT (COUNT(adhid) - COUNT(distinct tel)) FROM Adherent;

--> doit ramener 765, si c'est pas le cas :
--  Vrifier les doublons et les changer 

SELECT a1.adhid,a1.nom,a1.tel 
       FROM Adherent a1, Adherent a2
       WHERE a1.tel = a2.tel
       AND   a1.adhid<>a2.adhid;

--Exemple

     ADHID NOM                       TEL
---------- ------------------------- -----------------
       293 LAUNEY                    01-17-67-54-14
      1020 CHOCTEAU                  01-17-67-54-14
     16262 LERIBLE                   05-45-06-85-58
     19309 FASNACHT                  05-45-06-85-58

--> UPDATE Adherent SET tel='' WHERE tel ='' AND adhid = ;

UPDATE Adherent SET tel='votre portable' WHERE tel='01-17-67-54-14'  AND adhid = 1020 ;
UPDATE Adherent SET tel='un autre...'    WHERE tel ='05-45-06-85-58' AND adhid = 19309;
COMMIT;

-- fin du test de l'unicit --------------------------

-- pour vrifier, l'index doit pouvoir se crr

CREATE UNIQUE INDEX idx_adherent_tel_btree 
  ON Adherent (tel) TABLESPACE tbs_index;
DROP INDEX idx_adherent_tel_btree;

