
-- cls primaires

ALTER TABLE Sport
      ADD CONSTRAINT pk_Sport PRIMARY KEY (spid)
      USING INDEX TABLESPACE tbs_index;

ALTER TABLE Adherent
      ADD CONSTRAINT pk_Adherent PRIMARY KEY (adhid)
      USING INDEX TABLESPACE tbs_index;

ALTER TABLE Pratique
      ADD CONSTRAINT pk_Pratique PRIMARY KEY (adhid,spid)
      USING INDEX TABLESPACE tbs_index;

-- Mise en place des FK

BEGIN 
 DELETE FROM Pratique WHERE adhid NOT IN (SELECT adhid FROM Adherent);
 DELETE FROM Pratique WHERE spid NOT IN (SELECT spid FROM Sport);
 COMMIT;
END;
/

ALTER TABLE Pratique
      ADD CONSTRAINT fk_Pratique_Sport 
      FOREIGN KEY (spid) 
      REFERENCES Sport(spid);

ALTER TABLE Pratique
      ADD CONSTRAINT fk_Pratique_Adherent 
      FOREIGN KEY (adhid) 
      REFERENCES Adherent(adhid);

-- indexation des colonnes cls trangres

CREATE INDEX idx_Pratique_spid 
       ON Pratique (spid)
       TABLESPACE tbs_index;

CREATE INDEX idx_Pratique_adhid 
       ON Pratique (adhid)
       TABLESPACE tbs_index;

--Requte : adhrents inscrits  tous les sports

SET TIMING ON
SET AUTOTRACE ON

SELECT a.civilite,a.prenom,a.nom,a.tel FROM Adherent a
	WHERE NOT EXISTS
	 (SELECT spid FROM Sport
	  MINUS
	  SELECT spid FROM Pratique WHERE adhid = a.adhid)
	AND NOT EXISTS
	 (SELECT spid FROM Pratique WHERE adhid = a.adhid
	  MINUS
	  SELECT spid FROM Sport);

SET AUTOTRACE OFF
SET TIMING OFF

-- suppression des index dans la base sport

ALTER TABLE Pratique DROP CONSTRAINT fk_Pratique_Sport ;
ALTER TABLE Pratique DROP CONSTRAINT fk_Pratique_Adherent;

ALTER TABLE Pratique DROP CONSTRAINT pk_Pratique;
ALTER TABLE Adherent DROP CONSTRAINT pk_Adherent;
ALTER TABLE Sport    DROP CONSTRAINT pk_Sport;

DROP INDEX idx_Pratique_spid;
DROP INDEX idx_Pratique_adhid;

-- excuter  nouveau la requte sans index 
-- puis recrr les index (dbut fichier)

-- Vrification des index

SELECT table_name, last_analyzed FROM user_tables;
SELECT index_name, last_analyzed FROM user_indexes;
SELECT index_name, status        FROM user_indexes;

-- passer les stats sur les tables 
-- modifier 'SOUTOU' par votre user en majuscules

EXEC DBMS_STATS.gather_schema_stats('SOUTOU', cascade=>TRUE);

-- diffrentes opration sur les index

-- aucun index

SET AUTOTRACE ON
SELECT adhid,tel
       FROM Adherent 
       WHERE nom='GRIGNON' 
       AND prenom='BORIS' ;
SET AUTOTRACE OFF

-- index PK 

SET AUTOTRACE ON
SELECT nom,prenom,tel 
       FROM Adherent WHERE adhid=3861;
SET AUTOTRACE OFF

-- Cration de la base volumineuse

CREATE TABLE Adherentbis AS SELECT * FROM Adherent;
ALTER TABLE  Adherentbis MODIFY tel VARCHAR2(20);
ALTER TABLE  Adherentbis MODIFY adhid NUMBER(10);

CREATE TABLE temp AS SELECT * FROM Adherent;
ALTER TABLE  temp MODIFY adhid NUMBER(10);
ALTER TABLE  temp MODIFY tel VARCHAR2(20);

SELECT COUNT(adhid),MAX(adhid),MIN(adhid) FROM Adherent;

--> cration de plus d'1 milion d'adhrents 

DECLARE
 i NUMBER;
BEGIN
 FOR i in 1..48 LOOP
   UPDATE temp SET 
       tel= TO_CHAR('+'||i||'-'||tel)
       WHERE tel IS NOT NULL;
   IF (MOD(i,2)=1) THEN
       UPDATE temp SET adhid =  adhid+i*27000;
   ELSE
       UPDATE temp SET adhid =  (i+1)*27000 - adhid;
   END IF;
   INSERT INTO Adherentbis SELECT * FROM temp;
   COMMIT;   
   DELETE FROM temp;
   COMMIT;
   INSERT INTO temp SELECT * FROM Adherent;
   COMMIT;
 END LOOP; 
END;
/

SELECT COUNT(adhid),MAX(adhid),MIN(adhid) FROM Adherentbis;

SELECT COUNT(DISTINCT adhid) FROM Adherentbis;

SELECT COUNT(tel) FROM Adherentbis;

SELECT COUNT(DISTINCT tel) FROM Adherentbis;

SELECT SUBSTR(segment_name,1,30) segment_name, bytes/1024/1024 "Taille en Mo"
    FROM user_segments WHERE segment_name = 'ADHERENTBIS';

-- Table PratiqueBis

CREATE TABLE Pratiquebis AS SELECT * FROM Pratique;
DELETE FROM  Pratiquebis;
ALTER TABLE  Pratiquebis MODIFY adhid NUMBER(10);

DECLARE
 nbsp NUMBER;
 v Adherentbis.adhid%TYPE;
 v Sport.spid%TYPE;
BEGIN
 FOR v IN (SELECT adhid FROM Adherentbis) LOOP
  BEGIN 
  FOR s IN (SELECT spid FROM Sport) LOOP
     SELECT ABS(MOD(DBMS_RANDOM.RANDOM,2)) INTO nbsp FROM DUAL;
     IF nbsp = 1 THEN INSERT INTO Pratiquebis VALUES (v.adhid,s.spid);
                 ELSE EXIT;
     END IF;
   END LOOP;
  END;
END LOOP;
COMMIT;
END;
/

SELECT COUNT(*) FROM Pratiquebis;
SELECT COUNT(*) FROM Sport;

--> adh / sport
SELECT spid,COUNT(adhid) FROM Pratiquebis GROUP BY spid ORDER BY 1;

--> aucun sport
SELECT COUNT(adhid) FROM Adherentbis a 
   WHERE NOT EXISTS (SELECT spid FROM Pratiquebis WHERE adhid=a.adhid);

-- primary key 

ALTER TABLE Adherentbis 
      ADD CONSTRAINT pk_Adherentbis 
      PRIMARY KEY (adhid)
      USING INDEX TABLESPACE tbs_index;

ALTER TABLE Pratiquebis 
      ADD CONSTRAINT pk_Pratiquebis 
      PRIMARY KEY (adhid,spid)
      USING INDEX TABLESPACE tbs_index;

-- FK 

ALTER TABLE Pratiquebis
      ADD CONSTRAINT fk_Pratiquebis_Sport 
      FOREIGN KEY (spid) 
      REFERENCES Sport(spid);

ALTER TABLE Pratiquebis
      ADD CONSTRAINT fk_Pratiquebis_Adherent 
      FOREIGN KEY (adhid) 
      REFERENCES Adherentbis(adhid);

-- index sur cls trangres

CREATE INDEX idx_Pratiquebis_spid  
       ON Pratiquebis (spid)
       TABLESPACE tbs_index;

CREATE INDEX idx_Pratiquebis_adhid 
       ON Pratiquebis (adhid)
       TABLESPACE tbs_index;

-- Index et expressions

CREATE INDEX idx_adherent_nom
       ON Adherentbis (nom) TABLESPACE tbs_index;

CREATE INDEX idx_adherent_solde
       ON Adherentbis (solde) TABLESPACE tbs_index;

SELECT SUBSTR(segment_name,1,30) segment_name, bytes/1024/1024 "Taille en Mo"
       FROM user_segments 
       WHERE segment_name IN ('IDX_ADHERENT_NOM','IDX_ADHERENT_SOLDE');

SELECT index_name, status FROM user_indexes;

BEGIN
 DBMS_STATS.GATHER_TABLE_STATS (
   ownname => 'SOUTOU', 
   tabname => 'ADHERENTBIS', 
   method_opt => 'FOR ALL INDEXED COLUMNS',
   cascade => true);
END;
/

SET AUTOTRACE ON
-- 
SELECT prenom,tel 
       FROM Adherentbis 
       WHERE nom='DUCLOS' 
       AND civilite='Mr.' 
       AND tel LIKE '+33%';

SELECT prenom,tel 
       FROM Adherentbis 
       WHERE UPPER(nom)='DUCLOS' 
       AND civilite='Mr.' 
       AND tel LIKE '+33%';

SELECT COUNT(*) 
       FROM Adherentbis 
       WHERE ROUND(solde,1)=9030.8;

SELECT COUNT(*)  
       FROM Adherentbis 
       WHERE solde=9030.75;
--
SET AUTOTRACE OFF

-- suppression des index 

DROP INDEX idx_adherent_nom;
DROP INDEX idx_adherent_solde;

--cration des index fonction

CREATE INDEX idx_adherent_UPPERnom
       ON Adherentbis (UPPER(nom)) 
       TABLESPACE tbs_index;

CREATE INDEX idx_adherent_ROUNDsolde
       ON Adherentbis (ROUND(solde,1)) 
       TABLESPACE tbs_index;

SELECT SUBSTR(segment_name,1,30) segment_name, bytes/1024/1024 "Taille en Mo"
       FROM user_segments 
       WHERE segment_name IN ('IDX_ADHERENT_UPPERNOM','IDX_ADHERENT_ROUNDSOLDE');

SELECT index_name, status FROM user_indexes;

BEGIN
 DBMS_STATS.GATHER_TABLE_STATS (
   ownname => 'SOUTOU', 
   tabname => 'ADHERENTBIS', 
   method_opt => 'FOR ALL INDEXED COLUMNS',
   cascade => true);
END;
/

SET AUTOTRACE ON
-- 
SELECT prenom,tel FROM Adherentbis WHERE nom='DUCLOS' 
       AND civilite='Mr.' AND tel LIKE '+33%';

SELECT prenom,tel FROM Adherentbis WHERE UPPER(nom)='DUCLOS' 
       AND civilite='Mr.' AND tel LIKE '+33%';

SELECT COUNT(*) FROM Adherentbis WHERE ROUND(solde,1)=9030.8;

SELECT COUNT(*)  FROM Adherentbis WHERE solde=9030.75;
--
SET AUTOTRACE OFF

DROP INDEX idx_adherent_UPPERnom;
DROP INDEX idx_adherent_ROUNDsolde;

-- Index et valeurs nulles

SET AUTOTRACE ON
--
SELECT COUNT(a.nom) 
       FROM Adherentbis a 
       WHERE a.tel IS NULL;

SELECT DISTINCT(a.nom) 
       FROM Adherentbis a 
       WHERE a.tel = '......';

SELECT COUNT(a.nom) 
       FROM Adherentbis a 
       WHERE a.tel IS NOT NULL;
--
SET AUTOTRACE OFF


-- index classique

CREATE INDEX idx_tel_btree 
       ON Adherentbis (tel) 
       TABLESPACE tbs_index;

SELECT SUBSTR(segment_name,1,30) segment_name, bytes/1024/1024 "Taille en Mo"
       FROM user_segments 
       WHERE segment_name = 'IDX_TEL_BTREE';

-- index avec fonction

CREATE OR REPLACE FUNCTION f_tel_null
(p_tel Adherentbis.tel%type) RETURN NUMBER
DETERMINISTIC AS
BEGIN
  IF p_tel IS NULL THEN RETURN 1;
  ELSE RETURN NULL;
  END IF;
END f_tel_null;
/

DROP INDEX idx_tel_btree;

CREATE INDEX idx_tel_btree 
       ON Adherentbis (f_tel_null(tel)) 
       TABLESPACE tbs_index;

-- index compos

DROP INDEX idx_tel_btree;

CREATE INDEX idx_tel_btree 
       ON Adherentbis (tel,0) 
       TABLESPACE tbs_index;

-- index NVL2

DROP INDEX idx_tel_btree;

CREATE INDEX idx_tel_btree 
       ON Adherentbis (NVL2(tel,NULL,0)) 
       TABLESPACE tbs_index;

-- index UNIQUE

DROP INDEX idx_tel_btree;

CREATE UNIQUE INDEX idx_tel_btree 
       ON Adherentbis (tel) 
       TABLESPACE tbs_index;

-- fin test

DROP INDEX idx_tel_btree ;


-- Bitmap Indexes

SELECT DISTINCT civilite FROM Adherentbis;
SELECT civilite, COUNT(*) FROM Adherentbis GROUP BY civilite;

BEGIN
 DBMS_STATS.GATHER_TABLE_STATS (
   ownname => 'SOUTOU', 
   tabname => 'ADHERENTBIS', 
   method_opt => 'FOR ALL INDEXED COLUMNS',
   cascade => true);
END;
/


SET AUTOTRACE ON
-- 
SELECT COUNT(nom)
       FROM Adherentbis 
       WHERE civilite = 'Mr.';
SELECT COUNT(nom)
       FROM Adherentbis 
       WHERE civilite IN ('Mlle.','Mme.');
SELECT COUNT(nom) "nbre pas homme"
       FROM Adherentbis 
       WHERE NOT (civilite = 'Mr.');
--
SET AUTOTRACE OFF

-- bitmap

CREATE BITMAP INDEX idx_civilite_bitmap 
       ON Adherentbis (civilite)
       TABLESPACE tbs_index;

DROP INDEX idx_civilite_bitmap;

-- index btree

CREATE INDEX idx_civilite_btree 
       ON Adherentbis (civilite)
       TABLESPACE tbs_index;

DROP INDEX idx_civilite_btree;

-- Index et expressions


SET AUTOTRACE ON
-- 
SELECT COUNT(nom) 
  FROM Adherentbis 
  WHERE TO_CHAR(date_nais,'DD/MM/YYYY')='17/01/1980';

SELECT COUNT(DISTINCT nom),TO_CHAR(date_nais,'DD/MM/YYYY')
 FROM Adherentbis
 GROUP BY date_nais
 HAVING COUNT(DISTINCT nom)=6;

SELECT a1.tel,a1.nom,a1.date_nais
 FROM Adherentbis a1, Adherentbis a2
 WHERE NOT(a1.nom=a2.nom)
 AND a1.date_nais=a2.date_nais
 AND TO_CHAR(a1.date_nais,'DD/MM/YYYY')='17/01/1980';
--
SET AUTOTRACE OFF

-- index date

CREATE INDEX idx_datenais
       ON Adherentbis (date_nais) 
       TABLESPACE tbs_index;

DROP INDEX idx_datenais;

-- index sur TO_CHAR

CREATE INDEX idx_to_char_datenais
       ON Adherentbis (TO_CHAR(date_nais,'DD/MM/YYYY')) 
       TABLESPACE tbs_index;

DROP INDEX idx_to_char_datenais;

-- Taille d'un index

VARIABLE v_octets_index NUMBER
VARIABLE v_octets_segment  NUMBER
VARIABLE v_sql             CHAR(100)
EXEC    :v_sql:='CREATE UNIQUE INDEX idx_nom_pre_tel ON Adherentbis (nom,prenom,tel) TABLESPACE tbs_index'
EXEC DBMS_SPACE.CREATE_INDEX_COST(:v_sql,:v_octets_index, :v_octets_segment)
PRINT :v_octets_index
PRINT :v_octets_segment





