-- partitions

-- RANGE

CREATE TABLE Adherent_partition_range
 (adhid      NUMBER(10) NOT NULL, 
  nom        VARCHAR(25) NOT NULL, 
  prenom     VARCHAR(30) NOT NULL, 
  civilite   VARCHAR(12) NOT NULL, 
  date_nais  DATE NOT NULL,
  tel        VARCHAR2(20),
  solde      NUMBER(8,2))
PARTITION BY RANGE (date_nais)
 (PARTITION retraites 
     VALUES LESS THAN (TO_DATE('01/01/1945','DD/MM/YYYY'))
     TABLESPACE tbs_part1,
  PARTITION actifs    
     VALUES LESS THAN (TO_DATE('01/01/1993','DD/MM/YYYY'))
     TABLESPACE tbs_part2,
  PARTITION mineurs   
     VALUES LESS THAN (MAXVALUE)
     TABLESPACE tbs_part3); 

INSERT /*+ APPEND */ 
       INTO Adherent_partition_range 
       (adhid,nom,prenom,civilite,date_nais,tel,solde)   
       SELECT adhid,nom,prenom,civilite,date_nais,tel,solde 
              FROM Adherentbis;

--index locaux

CREATE INDEX Adherent_partition_idx
       ON Adherent_partition_range(date_nais) LOCAL;

-- collecte des stats

EXECUTE DBMS_STATS.GATHER_SCHEMA_STATS(ownname=>'SOUTOU',cascade=>true);

SET TIMING ON

SET AUTOTRACE TRACEONLY
SELECT a.adhid, a.prenom, a.nom 
  FROM Adherentbis a
  WHERE TO_CHAR(a.date_nais,'DD/MM/YYYY') >= '01/01/1920'
  AND   TO_CHAR(a.date_nais,'DD/MM/YYYY') <  '01/01/1945';
--
SELECT a.adhid, a.prenom, a.nom 
  FROM Adherent_partition_range a
  WHERE TO_CHAR(a.date_nais,'DD/MM/YYYY') >= '01/01/1920'
  AND   TO_CHAR(a.date_nais,'DD/MM/YYYY') <  '01/01/1945';
SET AUTOTRACE OFF

SET AUTOTRACE TRACEONLY
SELECT a.adhid, a.prenom, a.nom 
  FROM Adherentbis a
  WHERE TO_CHAR(a.date_nais,'DD/MM/YYYY') >  '01/01/1945'
  AND   TO_CHAR(a.date_nais,'DD/MM/YYYY') <  '01/01/1993';
--
SELECT a.adhid, a.prenom, a.nom 
  FROM Adherent_partition_range a
  WHERE TO_CHAR(a.date_nais,'DD/MM/YYYY') >  '01/01/1945'
  AND   TO_CHAR(a.date_nais,'DD/MM/YYYY') <  '01/01/1993';
-->PARTITION RANGE ALL
SET AUTOTRACE OFF

DROP TABLE Adherent_partition_range;  

-- INTERVAL

-- initialisation des soldes

DECLARE
 CURSOR cur IS SELECT adhid FROM Adherentbis
  FOR UPDATE OF solde NOWAIT;
 v Adherentbis.adhid%TYPE;
BEGIN
 FOR v IN cur LOOP  
  UPDATE Adherentbis SET solde = 
       (SELECT ROUND(ABS(DBMS_RANDOM.VALUE(0,30000)),2) FROM DUAL)
  WHERE CURRENT OF cur;
END LOOP;
COMMIT;
END;
/

select min(solde),max(solde),COUNT(distinct(solde))  from Adherentbis;

CREATE TABLE Adherent_part_range_interval
 (adhid      NUMBER(10) NOT NULL, 
  nom        VARCHAR(25) NOT NULL, 
  prenom     VARCHAR(30) NOT NULL, 
  civilite   VARCHAR(12) NOT NULL, 
  date_nais  DATE NOT NULL,
  tel        VARCHAR2(20),
  solde      NUMBER(8,2))
 PARTITION BY RANGE (solde)
 INTERVAL (8000)
 (PARTITION p1 VALUES LESS THAN (8001));

INSERT /*+ APPEND */ 
      INTO Adherent_part_range_interval
      (adhid,nom,prenom,civilite,date_nais,tel,solde)   
       SELECT adhid,nom,prenom,civilite,date_nais,tel,solde 
              FROM Adherentbis;

COL partition_name FORMAT A15
COL Limite FORMAT A15 HEADING 'Limite'
SELECT partition_name, high_value Limite 
  FROM user_tab_partitions
  WHERE table_name = 'ADHERENT_PART_RANGE_INTERVAL'
  ORDER BY 1;

-- collecte des stats

EXECUTE DBMS_STATS.GATHER_SCHEMA_STATS(ownname=>'SOUTOU',cascade=>true);

SET TIMING ON

SET AUTOTRACE TRACEONLY
SELECT a.adhid, a.prenom, a.nom 
  FROM Adherentbis a
  WHERE a.solde BETWEEN 10 AND 7000;
--
SELECT a.adhid, a.prenom, a.nom 
  FROM Adherent_part_range_interval a
  WHERE a.solde BETWEEN 10 AND 7000;
--
SELECT a.adhid, a.prenom, a.nom 
  FROM Adherentbis a
  WHERE a.solde =10 OR a.solde = 7000;
--
SELECT a.adhid, a.prenom, a.nom 
  FROM Adherent_part_range_interval a
  WHERE a.solde =10 OR a.solde = 7000;
SET AUTOTRACE OFF

SET TIMING OFF

DROP TABLE Adherent_part_range_interval;

-- hachage

CREATE TABLE Adherent_partition_hash
 (adhid      NUMBER(10) NOT NULL, 
  nom        VARCHAR(25) NOT NULL, 
  prenom     VARCHAR(30) NOT NULL, 
  civilite   VARCHAR(12) NOT NULL, 
  date_nais  DATE NOT NULL,
  tel        VARCHAR2(20),
  solde      NUMBER(8,2))
 PARTITION BY HASH (prenom)
 PARTITIONS 4
 STORE IN (tbs_part1, tbs_part2, tbs_part3, tbs_part4); 

INSERT /*+ APPEND */ INTO Adherent_partition_hash
      (adhid,nom,prenom,civilite,date_nais,tel,solde)   
       SELECT adhid,nom,prenom,civilite,date_nais,tel,solde 
              FROM Adherentbis;

--index global

ALTER TABLE Adherent_partition_hash
      ADD CONSTRAINT pk_Adh_partition_hash PRIMARY KEY(adhid);   

-- collecte des stats

EXECUTE DBMS_STATS.GATHER_SCHEMA_STATS(ownname=>'SOUTOU',cascade=>true);

SET TIMING ON

SET AUTOTRACE TRACEONLY
SELECT a.adhid, a.nom, a.tel
  FROM Adherentbis a
  WHERE a.prenom = 'CELINE';
--
SELECT a.adhid, a.prenom, a.nom 
  FROM Adherent_partition_hash a
  WHERE a.prenom = 'CELINE';
--
SELECT a.adhid, a.nom, a.tel
  FROM Adherentbis a
  WHERE a.prenom IN ('CELINE','VALERIE');
--
SELECT a.adhid, a.prenom, a.nom 
  FROM Adherent_partition_hash a
  WHERE a.prenom IN ('CELINE','VALERIE');
--
SELECT a.adhid, a.nom, a.tel
  FROM Adherentbis a
  WHERE a.nom LIKE 'D%';
--
SELECT a.adhid, a.prenom, a.nom 
  FROM Adherent_partition_hash a
   WHERE a.nom LIKE 'D%';
SET AUTOTRACE OFF

DROP TABLE Adherent_partition_hash; 

-- par liste (civilite)

CREATE TABLE Adherent_partition_list
 (adhid      NUMBER(10) NOT NULL, 
  nom        VARCHAR(25) NOT NULL, 
  prenom     VARCHAR(30) NOT NULL, 
  civilite   VARCHAR(12) NOT NULL, 
  date_nais  DATE NOT NULL,
  tel        VARCHAR2(20),
  solde      NUMBER(8,2))
 PARTITION BY LIST (civilite) 
  (PARTITION femmes VALUES ('Melle.', 'Mme.')
      TABLESPACE tbs_part1,
   PARTITION hommes VALUES ('Mr.')
      TABLESPACE tbs_part2,
   PARTITION autres VALUES (DEFAULT)
      TABLESPACE tbs_part3);

INSERT /*+ APPEND */ INTO Adherent_partition_list
       (adhid,nom,prenom,civilite,date_nais,tel,solde)   
       SELECT adhid,nom,prenom,civilite,date_nais,tel,solde 
              FROM Adherentbis;

--index global

ALTER TABLE Adherent_partition_list
      ADD CONSTRAINT pk_Adh_partition_list PRIMARY KEY(adhid);   

-- collecte des stats

EXECUTE DBMS_STATS.GATHER_SCHEMA_STATS(ownname=>'SOUTOU',cascade=>true);

SET TIMING ON

SET AUTOTRACE TRACEONLY
SELECT a.adhid, a.nom, a.tel
  FROM Adherentbis a
  WHERE a.prenom = 'CELINE'
  AND a.civilite = 'Melle.';
--
SELECT a.adhid, a.nom, a.tel
  FROM Adherent_partition_list a
  WHERE a.prenom = 'CELINE'
  AND a.civilite = 'Melle.';
--
SELECT a.adhid, a.nom, a.tel
  FROM Adherentbis a
  WHERE a.civilite IN ('Melle.','Mme.');
--
SELECT a.adhid, a.nom, a.tel
  FROM Adherent_partition_list a
  WHERE a.civilite IN ('Melle.','Mme.');
--
SELECT a.adhid, a.nom, a.tel
  FROM Adherentbis a;
--
SELECT a.adhid, a.nom, a.tel
  FROM Adherent_partition_list a;
SET AUTOTRACE OFF

DROP TABLE Adherent_partition_list;

-- reference partitions

CREATE TABLE Operateurs_partition_ref
 (opeid       CHAR(4) NOT NULL,
  nomope      VARCHAR(25) NOT NULL, 
  creaope     DATE NOT NULL,
  siegesocial VARCHAR(15) NOT NULL,
  nbclients   NUMBER(7) NOT NULL,
  CONSTRAINT  pk_Operateurs_partition_ref PRIMARY KEY(opeid))
  PARTITION BY RANGE(creaope)
    ( PARTITION P_1999_2003 VALUES LESS THAN (TO_DATE('01-01-2004','DD-MM-YYYY'))
                TABLESPACE tbs_part1,
      PARTITION P_2004_2007 VALUES LESS THAN (TO_DATE('01-01-2008','DD-MM-YYYY'))
                TABLESPACE tbs_part2,
      PARTITION P_apres_2008 VALUES LESS THAN (MAXVALUE) 
                TABLESPACE tbs_part3);

CREATE TABLE Adherent_partition_ref
 (adhid      NUMBER(10) NOT NULL, 
  nom        VARCHAR(25) NOT NULL, 
  prenom     VARCHAR(30) NOT NULL, 
  civilite   VARCHAR(12) NOT NULL, 
  date_nais  DATE NOT NULL,
  tel        VARCHAR2(20),
  solde      NUMBER(8,2),
  opeid      CHAR(4) NOT NULL,
  CONSTRAINT fk_adh_part_ref_operateurs
      FOREIGN KEY (opeid) 
      REFERENCES Operateurs_partition_ref(opeid)
  ) PARTITION BY REFERENCE(fk_adh_part_ref_operateurs);

INSERT /*+ APPEND */ INTO Operateurs_partition_ref
   SELECT * FROM Operateurs2;

select count(*) from adherentbis where 

INSERT /*+ APPEND */ INTO Adherent_partition_ref
       (adhid,nom,prenom,civilite,date_nais,tel,solde,opeid)   
       SELECT adhid,nom,prenom,civilite,date_nais,tel,solde,opeid_cle
              FROM Adherentbis;

DROP TABLE Adherent_partition_ref;
DROP TABLE Operateurs_partition_ref;

-- composite range-list

CREATE TABLE Adherent_range_list
 (adhid      NUMBER(10) NOT NULL, 
  nom        VARCHAR(25) NOT NULL, 
  prenom     VARCHAR(30) NOT NULL, 
  civilite   VARCHAR(12) NOT NULL, 
  date_nais  DATE NOT NULL,
  tel        VARCHAR2(20),
  solde      NUMBER(8,2))
PARTITION BY RANGE (date_nais)
  SUBPARTITION BY LIST (civilite)
   SUBPARTITION TEMPLATE
   ( SUBPARTITION femmes VALUES ('Melle.','Mme.'),
     SUBPARTITION hommes VALUES ('Mr.'), 
     SUBPARTITION autres VALUES (DEFAULT) )
 (PARTITION retraites 
     VALUES LESS THAN (TO_DATE('01/01/1945','DD/MM/YYYY'))
     TABLESPACE tbs_part1,
  PARTITION actifs    
     VALUES LESS THAN (TO_DATE('01/01/1993','DD/MM/YYYY'))
     TABLESPACE tbs_part2,
  PARTITION mineurs   
     VALUES LESS THAN (MAXVALUE)
     TABLESPACE tbs_part3);

INSERT /*+ APPEND */ INTO Adherent_range_list
      (adhid,nom,prenom,civilite,date_nais,tel,solde)   
       SELECT adhid,nom,prenom,civilite,date_nais,tel,solde
              FROM Adherentbis;
 
DROP TABLE Adherent_range_list;