
-- tkprof

-- sous votre user

ALTER SESSION SET TIMED_STATISTICS = TRUE;

ALTER SESSION SET MAX_DUMP_FILE_SIZE = 1000000;

WITH p AS
  (SELECT p.pid, p.spid, p.traceid
        FROM v$process p, v$session s
        WHERE p.addr = s.paddr
        AND s.sid = (SELECT DISTINCT sid FROM V$MYSTAT)
        AND s.server = 'DEDICATED'),
  s AS
  (SELECT CASE 
          WHEN BANNER LIKE '%Windows%' THEN '\' ELSE'/'
		END AS SEPARATOR 
        FROM V$VERSION
	WHERE BANNER LIKE 'TNS%')
 SELECT 
	(SELECT VALUE FROM V$PARAMETER WHERE NAME = 'user_dump_dest' ) ||
	s.separator || 'bdcs11gr2' || '_ORA_' ||
	p.spid || NVL2(p.traceid,  '_' || p.traceid, null ) || '.trc' fichier_trace
 FROM p, s;

-- sous system pour autoriser  tracer la session
-- modifiez "soutou" par votre nom de user

GRANT ALTER SESSION TO soutou;

ALTER SESSION SET sql_trace=TRUE;

--prfrez DBMS_SESSION 

BEGIN
  DBMS_SESSION.SET_SQL_TRACE (sql_trace => true);
END;
/

--excuter la requte

SELECT a.adhid, a.prenom, a.nom 
  FROM Adherent a, Pratique p, Sport s
  WHERE TO_NUMBER(TO_CHAR(DATE_NAIS,'YYYY')) < 1995
  AND TO_NUMBER(TO_CHAR(DATE_NAIS,'YYYY')) > 1954
  AND NOT (CIVILITE = 'Mr.')
  AND SUBSTR (TEL,1,2) = '06'
  AND  a.adhid = p.adhid
  AND  s.spid = p.spid
  AND  s.splibelle = 'Golf'
  ORDER BY nom;

ALTER SESSION SET sql_trace=FALSE;

--prfrez DBMS_SESSION 

BEGIN
  DBMS_SESSION.SET_SQL_TRACE (sql_trace => false);
END;
/

-- sous l'OS (modifiez les chemins)

tkprof c:\app\soutou\diag\rdbms\bdcs11gr2\bdcs11gr2\trace\BDCS11GR2_ORA_5928.trc C:\Temp\ma_trace.txt sys=no aggregate=no 
