-- Pivots

CREATE TABLE vols (
  id_vol  NUMBER,jour_id NUMBER,
  numVol  VARCHAR2(6),nb_passagers NUMBER);

INSERT INTO vols VALUES (1, 1, 'AF6143', 10);
INSERT INTO vols VALUES (2, 1, 'BA234', 20);
INSERT INTO vols VALUES (3, 1, 'CF56', 30);
INSERT INTO vols VALUES (4, 2, 'AF6143', 40);
INSERT INTO vols VALUES (5, 2, 'CF56', 50);
INSERT INTO vols VALUES (6, 3, 'AF6143', 60);
INSERT INTO vols VALUES (7, 3, 'BA234', 70);
INSERT INTO vols VALUES (8, 3, 'CF56', 80);
INSERT INTO vols VALUES (9, 3, 'D009', 90);
INSERT INTO vols VALUES (10, 4, 'AF6143', 100);
COMMIT;

SELECT id_vol,jour_id,numVol,nb_passagers FROM vols;

SELECT *   
  FROM  (SELECT numVol, nb_passagers FROM vols)
  PIVOT (SUM(nb_passagers) AS somme FOR (numVol) 
	IN ('AF6143' AS AF6143, 'BA234' AS BA234, 'CF56' AS CF56, 'D009' AS D009 ));

SELECT *   
  FROM  (SELECT jour_id, nb_passagers FROM vols)
  PIVOT (SUM(nb_passagers) AS somme, AVG(nb_passagers) AS moy FOR (jour_id) 
        IN (1 AS Lundi, 2 AS Mardi));

-- Modle  2 dimensions

WITH pivot_data AS 
	(SELECT jour_id, numVol, nb_passagers FROM vols)
    SELECT *
     FROM  pivot_data
     PIVOT (SUM(nb_passagers)       
           FOR jour_id          
           IN  (1 AS Lundi,2 AS Mardi,3 AS Mercredi) )
    WHERE NOT (numVol LIKE 'B%');

--option XML

SELECT *
   FROM   (SELECT numVol, nb_passagers FROM vols)
   PIVOT XML (SUM(nb_passagers) AS pax FOR (numVol) 
	   IN (SELECT DISTINCT numVol FROM vols));

SELECT *   
     FROM   (SELECT jour_id, nb_passagers FROM vols)
     PIVOT  XML (SUM(nb_passagers) AS somme, AVG(nb_passagers) AS moy 
            FOR jour_id IN (ANY));

DROP TABLE vols;

-- Unpivots

CREATE TABLE vols (
  id_vol  NUMBER,jour_id NUMBER,
  numVol  VARCHAR2(6),nb_passagers NUMBER);

INSERT INTO vols VALUES (1, 1, 'AF6143', 10);
INSERT INTO vols VALUES (2, 1, 'BA234', 20);
INSERT INTO vols VALUES (3, 1, 'CF56', 30);
INSERT INTO vols VALUES (4, 2, 'AF6143', 40);
INSERT INTO vols VALUES (5, 2, 'CF56', 50);
INSERT INTO vols VALUES (6, 3, 'AF6143', 60);
INSERT INTO vols VALUES (7, 3, 'BA234', 70);
INSERT INTO vols VALUES (8, 3, 'CF56', 80);
INSERT INTO vols VALUES (9, 3, 'D009', 90);
INSERT INTO vols VALUES (10, 4, 'AF6143', 100);
INSERT INTO vols VALUES (11, 1, 'AF6143', 50);
INSERT INTO vols VALUES (12, 5, 'AF6143', 180);
INSERT INTO vols VALUES (13, 6, 'D009', 10);

COMMIT;

SELECT id_vol,jour_id,numVol,nb_passagers FROM vols;

CREATE VIEW vols2 AS 
WITH pivot_data AS 
    (SELECT jour_id, numVol, nb_passagers FROM vols)
    SELECT *
     FROM  pivot_data
     PIVOT (SUM(nb_passagers)       
           FOR jour_id          
           IN  (1 AS Lundi,2 AS Mardi,3 AS Mercredi, 4 AS Jeudi, 5 AS Vendredi, 6 AS Samedi) );

SELECT * FROM vols2;

-- dtail par vol et par jour

SELECT *
  FROM vols2 
   UNPIVOT (passagers                             
           FOR jours    
           IN  (Lundi,Mardi, Mercredi, Jeudi, Vendredi, Samedi) 
           );

-- dtail par vol et par jour avec INCLUDE NULLS 

SELECT *
  FROM vols2 
   UNPIVOT INCLUDE NULLS (passagers                             
           FOR jours    
           IN  (Lundi,Mardi, Mercredi, Jeudi, Vendredi, Samedi))
  WHERE passagers IS NULL;

DROP TABLE vols;