
SET SERVEROUTPUT ON

DECLARE
  v_dateNaissance DATE; /* quivaut  v_dateNaissance DATE:= NULL;  */
  v_capacit      NUMBER(3) := 999;
  v_tlphone     CHAR(14) NOT NULL := '06-76-85-14-89';
--
  c_pi CONSTANT NUMBER := 3.14159;
  v_rayon       NUMBER := 1.5;
  v_aire        NUMBER := c_pi * v_rayon**2;
--
  v_groupeSanguin CHAR(3) := 'O+';  /* idem v_groupeSanguin CHAR(3) DEFAULT 'O+'; */
--
  v_dateValeur DATE := SYSDATE + 2;
  v_trouv BOOLEAN NOT NULL := TRUE;
BEGIN
	DBMS_OUTPUT.PUT_LINE ('Aire de rayon 1.5 = ' || TO_CHAR(v_aire));
END;
/


CREATE TABLE Pilote
	(brevet VARCHAR(6) CONSTRAINT pk_Pilote PRIMARY KEY,
	 nom VARCHAR(16), nbHVol NUMBER(7,2), compa CHAR(4));
INSERT INTO Pilote VALUES ('PL-1', 'Gratien Viel', 450, 'AF');
INSERT INTO Pilote VALUES ('PL-2', 'Didier Donsez', 0, 'AF');
INSERT INTO Pilote VALUES ('PL-3', 'Richard Grin', 1000, 'SING');
INSERT INTO Pilote VALUES ('PL-4', 'Placide Fresnais', 2450, 'CAST');
INSERT INTO Pilote VALUES ('PL-5', 'Daniel Vielle', NULL, 'AF');
SELECT * FROM Pilote;

DECLARE
  v_brevet Pilote.brevet%TYPE;
  v_prime  NUMBER(5,2) := 500.50;
  v_prime_min v_prime %TYPE := v_prime*0.9;
BEGIN
	DBMS_OUTPUT.PUT_LINE ('v_prime_min = ' || TO_CHAR(v_prime_min));
END;
/

--Affectations
DECLARE
  v_brevet    VARCHAR2(6);
  v_brevet2   VARCHAR2(6);
  v_prime     NUMBER(5,2);
  v_naissance DATE;
  v_trouv    BOOLEAN NOT NULL DEFAULT FALSE;
BEGIN
	v_brevet    := 'PL-1';
	v_brevet2   := v_brevet;
	v_prime     := 500.50;
	v_naissance := '04-07-2003';
	v_naissance := TO_DATE('04-07-2003 17:30','DD:MM:YYYY HH24:MI');
	v_trouv    := TRUE;
	SELECT brevet INTO v_brevet FROM Pilote WHERE nom = 'Gratien Viel';
END;
/
DROP TABLE Pilote;

--
CREATE TABLE Compagnie
	(comp VARCHAR2(4), nrue NUMBER(3), rue VARCHAR2(20), ville VARCHAR2(15), nomComp VARCHAR2(15),
 	CONSTRAINT pk_Compagnie PRIMARY KEY(comp));

CREATE TABLE Pilote
	(brevet VARCHAR2(6), nom CHAR(20), nbHVol NUMBER(7,2), compa VARCHAR2(4), chefPil VARCHAR2(6),
	 CONSTRAINT pk_Pilote PRIMARY KEY(brevet),
	 CONSTRAINT fk_Pil_compa_Comp FOREIGN KEY(compa) REFERENCES Compagnie(comp),
	 CONSTRAINT fk_Pil_chefPil_Pil FOREIGN KEY(chefPil) REFERENCES Pilote(brevet));
INSERT INTO Compagnie
	VALUES ('AF', 124, 'Port Royal', 'Paris', 'Air France');
INSERT INTO Compagnie
   VALUES ('SING', 7, 'Camparols', 'Singapour', 'Singapore AL');
INSERT INTO Compagnie
   VALUES ('CAST', 1, 'G. Brassens', 'Blagnac', 'Castanet AL');
INSERT INTO Pilote
 VALUES ('PL-4', 'Henri Alqui', 3400, 'AF',NULL);
INSERT INTO Pilote
 VALUES ('PL-1', 'Pierre Lamothe', 450, 'AF', 'PL-4');
INSERT INTO Pilote
 VALUES ('PL-2', 'Didier Linxe', 900, 'AF','PL-4');
INSERT INTO Pilote
 VALUES ('PL-3', 'Christian Soutou', 1000, 'SING',NULL);

--
DECLARE
   rty_pilote  Pilote%ROWTYPE;
   CURSOR curs1 IS SELECT comp, nomComp FROM Compagnie;
   compagnie_rec curs1%ROWTYPE;
   v_brevet Pilote.brevet%TYPE;
   v_comp   Compagnie.comp%TYPE;
BEGIN
--charger l'enreg
 SELECT * INTO rty_pilote FROM Pilote WHERE brevet='PL-1';
--le traiter par notation pointe
   v_brevet := rty_pilote.brevet;
--
 OPEN curs1;
 FETCH curs1 INTO compagnie_rec;
 v_comp  := compagnie_rec.comp;
-...
END;
/

--RECORD
DECLARE
  TYPE avionAirbus_rec IS RECORD
   (nserie CHAR(10), nomAvion CHAR(20),
    usine  CHAR(10) := 'Blagnac' , nbHVol NUMBER(7,2));
  r_unA320  avionAirbus_rec;
  r_FGLFS   avionAirbus_rec;
BEGIN
	r_unA320.nserie    := 'A1';
	r_unA320.nomAvion  := 'A320-200, Postale';
	r_unA320.nbHVol    := 2500.60;
	r_FGLFS            := r_unA320;
END;
/


--Tableaux
DECLARE
 TYPE brevets_tytab IS TABLE OF VARCHAR2(6)
      INDEX BY BINARY_INTEGER;
 TYPE nomPilotes_tytab IS TABLE OF Pilote.nom%TYPE
      INDEX BY BINARY_INTEGER;
 TYPE pilotes_tytab   IS TABLE OF Pilote%ROWTYPE 
      INDEX BY BINARY_INTEGER;
-- tableaux
 tab_brevets    brevets_tytab;
 tab_nomPilotes nomPilotes_tytab;
 tab_pilotes    pilotes_tytab;
BEGIN
  tab_brevets(-1) := 'PL-1';   
  tab_brevets(-2) := 'PL-2';   
  tab_nomPilotes(7800) := 'Bidal';
  tab_pilotes(0).brevet := 'PL-0';
--
  IF tab_pilotes.EXISTS(0) THEN
    DBMS_OUTPUT.PUT_LINE(' tab_pilotes(0)  prsent ');
  END IF;
  IF tab_nomPilotes.EXISTS(7800) THEN
    DBMS_OUTPUT.PUT_LINE(' tab_nomPilotes(7800) prsent ');
  END IF;
--
  DBMS_OUTPUT.PUT_LINE('Nombre lments de tab_brevets ' || tab_brevets.COUNT);	
--
  DBMS_OUTPUT.PUT_LINE('Premier indice tab_brevets ' ||  tab_brevets.FIRST);	
  DBMS_OUTPUT.PUT_LINE('Dernier indice tab_brevets ' ||  tab_brevets.LAST);
--prior 
  DBMS_OUTPUT.PUT_LINE('prior indice -1 tab_brevets ' ||  tab_brevets.PRIOR(-1));	
--delete
  tab_brevets.DELETE;
  DBMS_OUTPUT.PUT_LINE('Nombre lments de tab_brevets ' || tab_brevets.COUNT);	
END;
/

--Substitution
-- lancer avec start dans un fichier  part
ACCEPT s_brevet PROMPT 'Entrer code Brevet : '
ACCEPT s_dureVol PROMPT 'Entrer dure du vol : '
DECLARE
 v_nom    Pilote.nom%TYPE;
 v_nbHVol Pilote.nbHVol%TYPE;
BEGINc
   SELECT nom,nbHVol INTO v_nom, v_nbHVol FROM Pilote WHERE brevet = '&s_brevet';
   v_nbHVol := v_nbHVol + &s_dureVol;
   DBMS_OUTPUT.PUT_LINE ('Total heures vol : ' || v_nbHVol);
END;
/

DROP TABLE Pilote;
DROP TABLE Compagnie;


