
-- LIMIT et BULK COLLECT

CREATE TABLE Pilote
	(brevet VARCHAR2(6), nom CHAR(20), salaire NUMBER(7,2), compa VARCHAR2(4),
	 CONSTRAINT pk_Pilote PRIMARY KEY(brevet));

INSERT INTO Pilote VALUES ('PL-1', 'Henri Alqui', 3400, 'AF');
INSERT INTO Pilote VALUES ('PL-2', 'Pierre Lamothe', 4500, 'AF');
INSERT INTO Pilote VALUES ('PL-3', 'Didier Linxe', 9000, 'AF');
INSERT INTO Pilote VALUES ('PL-4', 'Christian Soutou', 10000, 'SING');
INSERT INTO Pilote VALUES ('PL-5', 'Gilles Laborde', 10050, 'SING');
INSERT INTO Pilote VALUES ('PL-6', 'Pierre Sry', 16000, 'SING');
INSERT INTO Pilote VALUES ('PL-7', 'Michel Castaings', 10000, 'CAST');
INSERT INTO Pilote VALUES ('PL-8', 'Jules Ente', 15000, 'CAST');
INSERT INTO Pilote VALUES ('PL-9', 'C. Sigaudes', 14000, 'CAST');
INSERT INTO Pilote VALUES ('PL-10', 'P. Filloux', 1000, 'AF');
INSERT INTO Pilote VALUES ('PL-11', 'S. Lacombe', 4000, 'CAST');
INSERT INTO Pilote VALUES ('PL-12', 'G. Diffis', 10060, 'SING');
COMMIT;

CREATE OR REPLACE PROCEDURE p_traite_all_rows (limite IN PLS_INTEGER DEFAULT 10)
IS
    CURSOR pilotes_cur IS SELECT * FROM Pilote;
    TYPE Pilote_tytab IS TABLE OF Pilote%ROWTYPE INDEX BY BINARY_INTEGER;
    tab_pilote Pilote_tytab;
BEGIN   
    OPEN pilotes_cur;
    LOOP
        FETCH pilotes_cur BULK COLLECT INTO tab_pilote LIMIT limite;
	-- 100 Pilotes au plus sont dans le tableau
        FOR i IN 1 .. tab_pilote.COUNT 
        LOOP
	  DBMS_OUTPUT.PUT_LINE(tab_pilote(i).nom);
        END LOOP;
        EXIT WHEN tab_pilote.COUNT < limite;
   END LOOP;
   CLOSE pilotes_cur;
END p_traite_all_rows;
/


SET SERVEROUT ON

BEGIN
    p_traite_all_rows ;
END;
/

CREATE OR REPLACE PROCEDURE p_traite_bug_rows (limite IN PLS_INTEGER DEFAULT 10)
IS
    CURSOR pilotes_cur IS SELECT * FROM Pilote;
    TYPE Pilote_tytab IS TABLE OF Pilote%ROWTYPE INDEX BY BINARY_INTEGER;
    tab_pilote Pilote_tytab;
BEGIN   
    OPEN pilotes_cur;
    LOOP
        FETCH pilotes_cur BULK COLLECT INTO tab_pilote LIMIT limite;
	  EXIT WHEN pilotes_cur%NOTFOUND;     /* source du problme */
	-- si moins de 10 Pilotes sont dans le tableau on ne passe pas ici
        FOR i IN 1 .. tab_pilote.COUNT 
        LOOP
	  DBMS_OUTPUT.PUT_LINE(tab_pilote(i).nom);
        END LOOP;
   END LOOP;
   CLOSE pilotes_cur;
END p_traite_bug_rows;
/


SET SERVEROUT ON

BEGIN
    p_traite_bug_rows;
END;
/

DROP PROCEDURE p_traite_bug_rows;
DROP PROCEDURE p_traite_all_rows;

DROP TABLE Pilote;
