
-- Fonctions table pipe lined

CREATE TABLE Pilote
	(brevet VARCHAR2(6), nom CHAR(20), salaire NUMBER(7,2), compa VARCHAR2(4),
	 CONSTRAINT pk_Pilote PRIMARY KEY(brevet));

INSERT INTO Pilote VALUES ('PL-1', 'Henri Alqui', 3400, 'AF');
INSERT INTO Pilote VALUES ('PL-2', 'Pierre Lamothe', 4500, 'AF');
INSERT INTO Pilote VALUES ('PL-3', 'Didier Linxe', 9000, 'AF');
INSERT INTO Pilote VALUES ('PL-4', 'Christian Soutou', 10000, 'SING');
INSERT INTO Pilote VALUES ('PL-5', 'Gilles Laborde', 10050, 'SING');
INSERT INTO Pilote VALUES ('PL-6', 'Pierre Sry', 16000, 'SING');
INSERT INTO Pilote VALUES ('PL-7', 'Michel Castaings', 10000, 'CAST');
INSERT INTO Pilote VALUES ('PL-8', 'Jules Ente', 15000, 'CAST');
COMMIT;


CREATE OR REPLACE PACKAGE PKG_Pilotes
IS
  TYPE Pilote_tytab
	IS TABLE OF Pilote%ROWTYPE;
  FUNCTION f_pilotes_comp_pipelined (v_comp IN VARCHAR2) 
		RETURN Pilote_tytab PIPELINED;
END PKG_Pilotes;
/

CREATE OR REPLACE PACKAGE BODY PKG_Pilotes
IS
  FUNCTION f_pilotes_comp_pipelined (v_comp IN VARCHAR2) 
		RETURN Pilote_tytab PIPELINED  IS
     CURSOR Pilote_Comp_Cur IS SELECT * FROM Pilote WHERE compa=v_comp;
     rty_pilote Pilote%ROWTYPE;
  BEGIN 
     OPEN Pilote_Comp_Cur;
     FETCH Pilote_Comp_Cur INTO rty_pilote;
     WHILE (Pilote_Comp_Cur%FOUND) LOOP
       PIPE ROW(rty_pilote);
       FETCH Pilote_Comp_Cur INTO rty_pilote;
     END LOOP;
     CLOSE Pilote_Comp_Cur;
  END ;
END PKG_Pilotes;
/
SELECT brevet,nom,salaire FROM 
	TABLE(PKG_Pilotes.f_pilotes_comp_pipelined('SING'));


DROP PACKAGE PKG_Pilotes;

DROP TABLE Pilote;
