
CLEAR COLUMNS
SET PAGESIZE 50

COL jour     FORMAT A10
COL vehicule FORMAT A10
COL employe    FORMAT A10
COL conducteur FORMAT A10
COL passager   FORMAT A10

-- Dtail des visites des passagers d'un mois donn

CREATE VIEW chantier_passagers (chantier,jour,vehicule,passager,conducteur,temps)
AS SELECT v.n_chantier, v.date_jour,v.n_vehicule,t.n_transporte,v.n_conducteur,v.temps_trajet
	FROM transporter t, visite v
	WHERE TO_CHAR(v.date_jour,'YYYY-MM') = '2008-04'
	AND v.n_chantier = t.n_chantier
	AND v.n_vehicule = t.n_vehicule
	AND v.date_jour  = t.date_jour
	ORDER BY 1,2,3;

SELECT * FROM chantier_passagers ;

-- Temps pass par les conducteurs des missions d'un mois donn

CREATE VIEW chantier_conducteur (chantier,conducteur,jour,temps) AS
SELECT n_chantier,n_conducteur,date_jour,SUM(temps_trajet)
	FROM visite
	WHERE TO_CHAR(date_jour,'YYYY-MM') = '2008-04'
	GROUP BY n_conducteur, n_chantier, date_jour
	ORDER BY 1,2,3;

SELECT * FROM chantier_conducteur ;

-- Temps pass par les employs (conducteurs et passagers) des visites d'un mois donn

CREATE VIEW chantier_conducteur_passagers (chantier,employe,jour,temps) AS
SELECT chantier,conducteur,jour,temps
	FROM chantier_conducteur
UNION
SELECT chantier,passager,jour,temps
	FROM chantier_passagers;

SELECT * FROM chantier_conducteur_passagers;

-- Temps pass sur la route par les employs qu'ils soient conducteur ou passager
-- d'un mois donn

SELECT  employe,SUM(temps) "Temps pass"
	FROM chantier_conducteur_passagers
	GROUP BY employe
	ORDER BY 1;


-- On veut facturer le temps pass par les employs par chantier 
 (formule : nombre d'employ * temps passe * 30 euros)

SELECT  chantier,SUM(temps),COUNT(employe), SUM(temps)*COUNT(employe)*30 "PRIX"
	FROM chantier_conducteur_passagers
	GROUP BY chantier
	ORDER BY 1;

