-- Algorithme Chien
-- definition de la classe Chien specialisant la classe Quadrupede
--
-- 	la classe Chien possede 2 attributs (prives) 
--	et trois methodes ( publiques) + un constructeur
--

with Ada.Text_IO;
use Ada.Text_IO;
 
with Ada.Strings.UnBounded;
use Ada.Strings.UnBounded;

with Quadrupede; use Quadrupede;

------ 
package Chien is                             -- la classe Chien
 
 package Strings renames Ada.Strings.Unbounded;  -- on utilise les chaines de caracteres

 type T_Chien is new T_Quadrupede with -- private with 
 record 
	nom : Strings.Unbounded_String; 
	proprietaire : Strings.Unbounded_String; 
 end record;
 
  procedure typeDeCri(p:T_Chien);        -- les methodes
  procedure sonProprietaire(p:T_Chien);
  procedure sonNom(p:T_Chien);
 
end Chien;    
--------------------------------------------
