 -- Algorithme Date
 -- definition de la classe Date
 --
 
with Text_Io; use Text_Io;      -- pour les entrees-sorties
 
with Ada.Strings.UnBounded;
use Ada.Strings.UnBounded;      -- utilisation des Chaines de caracteres
 
package body Date is        -- la classe Date

--	package Strings renames Ada.Strings.Unbounded;-- utilisation des Chaines de caracteres renommee Strings

--------------------------
procedure CopieDate (p:out T_Date; p_a_copier:T_Date) is
begin
	p.jour:=p_a_copier.jour;
	p.mois:=p_a_copier.mois;
	p.annee:=p_a_copier.annee;
end CopieDate;

--------------------------
function jour (p:T_Date) return Integer is
begin
	return (p.jour);
end jour;

--------------------------
function mois (p:T_Date) return Integer is
begin
	return (p.mois);
end mois;

--------------------------
function annee (p:T_Date) return Integer is
begin
	return (p.annee);
end annee;

--------------------------
function dateEnChaine (p:T_Date) return Strings.Unbounded_String is
	resultat : Strings.Unbounded_String; 
	car : String(1..1):="/";
begin
	resultat := Strings.To_Unbounded_String(Integer'Image(p.jour));
	resultat := resultat & car;
	resultat := resultat & Strings.To_Unbounded_String(Integer'Image(p.mois));
	resultat := resultat & car;
	resultat := resultat & Strings.To_Unbounded_String(Integer'Image(p.annee));
	return  (resultat);
end dateEnChaine;

--------------------------
function dateEnChaineComplete (p:T_Date) return Strings.Unbounded_String is
	resultat : Strings.Unbounded_String; 
	car : String(1..1):="/";
begin

	resultat := Strings.To_Unbounded_String(Integer'Image(p.jour));
	if (p.mois = 1) then resultat := resultat & " Janvier ";
	elsif (p.mois = 2) then resultat := resultat & " Fevrier ";
	elsif (p.mois = 3) then resultat := resultat & " Mars ";
	elsif (p.mois = 4) then resultat := resultat & " Avril ";
	elsif (p.mois = 5) then resultat := resultat & " Mai ";
	elsif (p.mois = 6) then resultat := resultat & " Juin " ;
	elsif (p.mois = 7) then resultat := resultat & " Juillet ";
	elsif (p.mois = 8) then resultat := resultat & " Aout ";
	elsif (p.mois = 9) then resultat := resultat & " Septembre ";
	elsif (p.mois = 10) then  resultat := resultat & " Octobre ";
	elsif (p.mois = 11) then  resultat := resultat & " Novembre ";
	elsif (p.mois = 12) then  resultat := resultat & " Decembre ";
	end if;
 
	resultat := resultat & Strings.To_Unbounded_String(Integer'Image(p.annee));

	return  (resultat);
end dateEnChaineComplete;

--------------------------
function estBissextile (p:in T_Date) return boolean is
reste, DeuxPremierChiffre,siecle : Integer :=0;
begin
	siecle := p.annee MOD 100 ;
	DeuxPremierChiffre := p.annee / 100 ;
	reste := p.annee MOD 4 ;

	if ((DeuxPremierChiffre MOD 4) = 0 AND (siecle = 0) ) then
		return True ;	-- les annees 1600, 2000, 2200 ... ne sont pas bissextiles
	end if;
	if (siecle = 0 ) then
		return  False ;	-- les annes 1800, 1900 ... sont bissextiles
	end if;
	if ((reste MOD 4) = 0 ) then
		return  True;	-- les annes divisibles par 4 sont bissextiles
	else
		return False;
	end if;
end estBissextile;

--------------------------
function estEgale (p:T_Date; p1:T_Date) return boolean is
begin
	if ( p.annee=p1.annee AND p.mois=p1.mois AND p.jour=p1.jour ) then
		return True ;            -- mme anne, mme mois et mme jour !
	else
		return False ;
	end if;
end ;

--------------------------
function precede (p:T_Date; p1:T_Date) return boolean is
begin
	if (p.annee < p1.annee) then
		return True ;	-- comparaison des annes
	end if;
	if (p.annee=p1.annee AND p.mois < p1.mois ) then
		return True ;	-- mme anne, comparaison des mois
	end if;
	if (p.annee=p1.annee AND p.mois=p1.mois AND p.jour < p1.jour ) then
		return True ;	-- mme anne et mme mois, comparaison des jours
	else
		return False ;
	end if;

end ;
 
end Date;
---------------------------------------------------    

--	public Chaine dateEnChaineComplete( ) {
--		Chaine resultat, chaineTemp;

--		resultat = new Chaine( );
--		chaineTemp = new Chaine();
--		resultat.init(jour) ;
--resultat.ecrire();
--		if (mois == 1) chaineTemp.init(" Janvier ");
--		if (mois == 2) chaineTemp.init(" Fevrier ");		
--		if (mois == 3) chaineTemp.init(" Mars ");
--		if (mois == 4) chaineTemp.init(" Avril ");
--		if (mois == 5) chaineTemp.init(" Mai ");		
--		if (mois == 6) chaineTemp.init(" Juin ") ;
--		if (mois == 7) chaineTemp.init(" Juillet ");
--		if (mois == 8) chaineTemp.init(" Aout ");		
----		if (mois == 9) chaineTemp.init(" Septembre ");
--		if (mois == 10) chaineTemp.init(" Octobre ");
--		if (mois == 11) chaineTemp.init(" Novembre ");		
--		if (mois == 12) chaineTemp.init(" Dcembre ");		

--		resultat.concatene(chaineTemp) ;
--		chaineTemp.init(annee) ;
--		resultat.concatene(chaineTemp) ;

--		return resultat ;
