 -- Algorithme : la classe Date
 -- Attention : le package Date existe deja en ADA : nous le redefinissons !!!
 --
 -- La classe Date possede de nombreuses mthodes :
 -- initDate(jour, mois, an : entier) retourne vide
 -- initDate(d : Date) retourne vide
 -- dateEnChaine( ) retourne Chaine 
 -- dateEnChaineComplete( ) retourne Chaine 
 -- jour( ) retourne entier 
 -- mois( ) retourne entier 
 -- annee( ) retourne entier
 -- estBissextile( ) retourne Boolen 
 -- precede(d : Date) retourne Boolen 
 -- estEgale(d : Date) retourne Boolen
 --
   
 -- la classe Date utilise la classe Chaine
with Ada.Text_IO; use Ada.Text_IO;
 
with Ada.Strings.UnBounded; use Ada.Strings.UnBounded;
 
package Date is                           -- la classe Quadrupede
 
 package Strings renames Ada.Strings.Unbounded; -- on utilise les chaines de caracteres
 
 type T_Date is tagged                    -- les attributs sont encapsules
 record
        jour   : Integer :=0;
        mois   : Integer :=0;
        annee  : Integer :=0;
 end record;
 
 type T_Ptr_Date is access T_Date;  -- Pointeur sur une Date
 
        procedure CopieDate (p:out T_Date; p_a_copier:T_Date);
        function jour (p:T_Date) return Integer;
        function mois (p:T_Date) return Integer;
        function annee (p:T_Date) return Integer;
        function dateEnChaine (p:T_Date) return Strings.Unbounded_String;
        function dateEnChaineComplete (p:T_Date) return Strings.Unbounded_String;
        function estBissextile (p:T_Date) return boolean;
        function estEgale (p:T_Date;p1:T_Date) return boolean;
        function precede (p:T_Date;p1:T_Date) return boolean;
 
end Date;
--------------------------------------------------   
