/**
 * Algorithme : la classe Date
 *
 * Attention : la classe Date existe dj en JAVA : nous le redfinissons !!!
 *
 * La classe Date possde de nombreuses mthodes :
 *
 * initDate(jour, mois, an : entier) retourne vide
 * initDate(d : Date) retourne vide
 * dateEnChaine( ) retourne Chaine 
 * dateEnChaineComplete( ) retourne Chaine 
 * jour( ) retourne entier 
 * mois( ) retourne entier 
 * annee( ) retourne entier
 * estBissextile( ) retourne Boolen 
 * precede(d : Date) retourne Boolen 
 * estEgale(d : Date) retourne Boolen
 *
 * @author Dabancourt C.
 * @version 1.0 08/08/2000
 */
   

#include "Date.h" 		// on utilise la classe date
#include <iostream.h>

#include "chaine.h"
#include <string.h>
#include <assert.h>
#include <stdlib.h>      

Date::Date () {
		jour=0; mois=0; annee=0;
	}
	
	
Date::Date(int jour,int mois,int an) {
		this->jour=jour; 
		this->mois=mois; 
		this->annee=an;
	}
	

Date::Date( Date & paramDate )  {
		jour = paramDate->getJour( ) ;
		mois = paramDate->getMois( ) ;
		annee = paramDate->getAnnee( ) ;
	}


// les mthodes appeles "accesseurs"
int Date::getJour( ) const { return jour;}
int Date::getMois( ) const { return mois;}
int Date::getAnnee( ) const { return annee;}


// les mthodes d'affichage
Chaine & Date::dateEnChaine( ) const {
	
	Chaine *resultat, *chaineTemp ;

	resultat = new Chaine( ) ;
	chaineTemp = new Chaine() ;

	resultat->init(jour) ;

	chaineTemp->init("/" );
	resultat->concatene(*chaineTemp) ;

	chaineTemp->init(mois);
	resultat->concatene(*chaineTemp) ;

	chaineTemp->init("/" );
	resultat->concatene(*chaineTemp) ;

	chaineTemp->init(annee);
	resultat->concatene(*chaineTemp) ;

	return  &resultat;
}

Chaine & Date::dateEnChaineComplete( ) const {
	Chaine *resultat, *chaineTemp;

	resultat = new Chaine( );
	chaineTemp = new Chaine();
	resultat->init(jour) ;
	resultat->ecrire();
	if (mois == 1) chaineTemp->init(" Janvier ");
	if (mois == 2) chaineTemp->init(" Fevrier ");		
	if (mois == 3) chaineTemp->init(" Mars ");
	if (mois == 4) chaineTemp->init(" Avril ");
	if (mois == 5) chaineTemp->init(" Mai ");		
	if (mois == 6) chaineTemp->init(" Juin ") ;
	if (mois == 7) chaineTemp->init(" Juillet ");
	if (mois == 8) chaineTemp->init(" Aout ");		
	if (mois == 9) chaineTemp->init(" Septembre ");
	if (mois == 10) chaineTemp->init(" Octobre ");
	if (mois == 11) chaineTemp->init(" Novembre ");		
	if (mois == 12) chaineTemp->init(" Dcembre ");		

	resultat->concatene(*chaineTemp) ;
	chaineTemp->init(annee) ;
	resultat->concatene(*chaineTemp) ;

	return &resultat ;
}

// les mthodes de Test
Bool Date::estBissextile( ) const {

	int reste, DeuxPremierChiffre,siecle ;

	siecle = annee % 100 ;
	DeuxPremierChiffre = annee / 100 ;
	reste = annee % 4 ;

	if ((DeuxPremierChiffre % 4) == 0 && (siecle == 0) ) 
		return VRAI ;            // les annes 1600, 2000, 2200 ... ne sont pas bissextiles
	if (siecle == 0 )  
		return  FAUX ;            // les annes 1800, 1900 ... sont bissextiles
	if ((reste % 4) == 0 )  
		return  VRAI;            // les annes divisibles par 4 sont bissextiles
	return FAUX;
}


Bool Date::estEgale(const Date & DateParam)  const {
	if ( annee==DateParam->getAnnee() && mois==DateParam->getMois( ) && jour==DateParam->getJour() ) 
		return VRAI ;            // mme anne, mme mois et mme jour !
	else
		return FAUX ;
}

Bool Date::precede(const Date &) const {
	if (annee < DateParam->getAnnee( ))  
		return VRAI ;		   // comparaison des annes
	if (annee==DateParam->getAnnee( ) && mois < DateParam->getMois( ) )  
		return VRAI ;	   // mme anne, comparaison des mois
	if (annee==DateParam->getAnnee( ) && mois==DateParam->getMois( ) && jour < DateParam->getJour( ))  
		return VRAI ;   // mme anne et mme mois, comparaison des jours

	return FAUX ;
}

