/**
 * Algorithme : la classe Date
 *
 * Attention : la classe Date existe dj en JAVA : nous le redfinissons !!!
 *
 * La classe Date possde de nombreuses mthodes :
 *
 * initDate(jour, mois, an : entier) retourne vide
 * initDate(d : Date) retourne vide
 * dateEnChaine( ) retourne Chaine 
 * dateEnChaineComplete( ) retourne Chaine 
 * jour( ) retourne entier 
 * mois( ) retourne entier 
 * annee( ) retourne entier
 * estBissextile( ) retourne Boolen 
 * precede(d : Date) retourne Boolen 
 * estEgale(d : Date) retourne Boolen
 *
 * @author Dabancourt C.
 * @version 1.0 08/08/2000
 */
   
 // la classe Date utilise la classe Chaine


class Date
{
	
	private int jour, mois, annee;		// attribut privs

// les mthodes appeles "constructeur"
	Date () {
		jour=0; mois=0; annee=0;
	}
	
	
	Date(int jour,int mois,int an) {
		this.jour=jour; this.mois=mois; this.annee=an;
	}
	

	Date(Date paramDate )  {
		jour = paramDate.jour( ) ;
		mois = paramDate.mois( ) ;
		annee = paramDate.annee( ) ;
	}


// les mthodes appeles "accesseurs"
	public int jour( ){ return jour;}
	public int mois( ){ return mois;}
	public int annee( ){ return annee;}


// les mthodes d'affichage
	public Chaine dateEnChaine( ) {
	
		Chaine resultat, chaineTemp ;


		resultat = new Chaine( ) ;
		chaineTemp = new Chaine() ;
		resultat.init(jour) ;

		chaineTemp.init("/" );
		resultat.concatene(chaineTemp) ;

		chaineTemp.init(mois);
		resultat.concatene(chaineTemp) ;

		chaineTemp.init("/" );
		resultat.concatene(chaineTemp) ;

		chaineTemp.init(annee);
		resultat.concatene(chaineTemp) ;

		return  resultat;
	}


	public Chaine dateEnChaineComplete( ) {
		Chaine resultat, chaineTemp;

		resultat = new Chaine( );
		chaineTemp = new Chaine();
		resultat.init(jour) ;
resultat.ecrire();
		if (mois == 1) chaineTemp.init(" Janvier ");
		if (mois == 2) chaineTemp.init(" Fevrier ");		
		if (mois == 3) chaineTemp.init(" Mars ");
		if (mois == 4) chaineTemp.init(" Avril ");
		if (mois == 5) chaineTemp.init(" Mai ");		
		if (mois == 6) chaineTemp.init(" Juin ") ;
		if (mois == 7) chaineTemp.init(" Juillet ");
		if (mois == 8) chaineTemp.init(" Aout ");		
		if (mois == 9) chaineTemp.init(" Septembre ");
		if (mois == 10) chaineTemp.init(" Octobre ");
		if (mois == 11) chaineTemp.init(" Novembre ");		
		if (mois == 12) chaineTemp.init(" Dcembre ");		

		resultat.concatene(chaineTemp) ;
		chaineTemp.init(annee) ;
		resultat.concatene(chaineTemp) ;

		return resultat ;
	}

// les mthodes de Test
	public boolean estBissextile( ) {
	int reste, DeuxPremierChiffre,siecle ;

		siecle = annee % 100 ;
		DeuxPremierChiffre = annee / 100 ;
		reste = annee % 4 ;

		if ((DeuxPremierChiffre % 4) == 0 && (siecle == 0) ) 
			return true ;            // les annes 1600, 2000, 2200 ... ne sont pas bissextiles
		if (siecle == 0 )  
			return  false ;            // les annes 1800, 1900 ... sont bissextiles
		if ((reste % 4) == 0 )  
			return  true;            // les annes divisibles par 4 sont bissextiles
		return false;
	}


	public boolean  estEgale(Date DateParam ) {
		if ( annee==DateParam.annee() && mois==DateParam.mois( ) && jour==DateParam.jour() ) 
			return true ;            // mme anne, mme mois et mme jour !
		else
			return false ;
	}

	public boolean  precede(Date DateParam ) {
		if (annee < DateParam.annee( ))  
			return true ;		   // comparaison des annes
		if (annee==DateParam.annee( ) && mois < DateParam.mois( ) )  
			return true ;	   // mme anne, comparaison des mois
		if (annee==DateParam.annee( ) && mois==DateParam.mois( ) && jour < DateParam.jour( ))  
			return true ;   // mme anne et mme mois, comparaison des jours

		return false ;
	}





//////////////////utilisation de la classe Date (tester les mthodes).
	public static void main ( String [] argv)
	{
	 Date	d, d0;

		d = new Date(5,10,1992 ) ;
		d.dateEnChaineComplete().ecrire();
		d0 = new Date( d ) ;

		if (d0.estBissextile( ) == true) 
			System.out.println(d0.dateEnChaine().getString() + " est bissextile.");
	 Date d1;
		d1=new Date(7,8,1492);
		if (d1.precede(d))
			System.out.println(d1.dateEnChaine().getString() + " precede "+ d.dateEnChaine().getString());
	}      	
}
