/**
 * Classe DICTIONNAIRE 
 * la classe Dictionnaire utilise un tableau d'instances de Definition.
 * la classe Test a t faite pour tester la classe Dictionnaire grace a un menu.
 *
 * Attention : le premier mot du dictionnaire est  l'indice 1.
 * l'indice 0 du tableau tab est inutilis.
 * @author Dabancourt C.
 * @version 1.0 08/08/2000
 */
   
import java.io.*;		// bibliothque utilise pour les Entres/Sorties
import java.lang.String;

/** Liste des attributs et mthodes :
 * - Entre : tableau de Definition [ ]
 * - int nbMot : Entier
 *    
 * + dictionnaire( ) retourne vide
 * + trier ( )retourne vide
 * + lister ( )retourne vide
 * + ajouter ( )retourne vide
 * + recherche (Chaine mot) retourne Entier
 */




class Dictionnaire
{
	private int nbMot;
	private Definition[] tab;
	
	Dictionnaire( )
	{	
		int indice;
		Definition definition;
		tab = new Definition[101];		// constructeur de tableau : rservation mmoire : indice de 0  99
		Definition def = new Definition( ) ;	// constructeur de def : rservation mmoire
	
		System.out.print(" combien voulez-vous entrez de mots ? ") ;
		nbMot=lire() ;				// On fait Lire le nombre dlments  saisir : nbMot
	
		indice = 1 ;
		while (indice <= nbMot) 		// On fait une boucle pour parcourir 
		{					// tous les lments (de 1  nbMot)
			def = new Definition( ) ;	
			def.saisir( ) ;			// lutilisateur saisit une nouvelle Definition 
			tab[indice] = def ;		// tab contient des instances de Definition !
			indice = indice + 1 ;		// au mot suivant...
		}
		this.trier() ;				// on noublie de trier le dictionnaire
		this.lister();

	}

	public Definition getDefinition(int i )
	{
		return (tab[i]);	
	}
	
	public void trier( )
	{
		int	indice;
		boolean	poursuivre ;
		Definition Def_temporaire ;
	
		Def_temporaire = new Definition( ) ;

		if (nbMot>2)
			poursuivre = true ;
		else
			poursuivre = false;
			

		while ( poursuivre )
		{ 
			poursuivre = false ;
			indice = 2 ;
	
			while ( indice <= nbMot ) 
			{
				if ( (tab[indice].accederMot()).compareTo(tab[indice-1].accederMot()) < 0 )
				{
					Def_temporaire.copier( tab[indice] ) ;
					tab[indice]= tab[indice-1] ;
					tab[indice -1]= Def_temporaire;
					
					poursuivre = true;
				}
				indice = indice + 1 ;
			}
		}
	}


	public void lister( ) 
	{
		int indice;
		
		indice = 1 ;
		while ( indice <= nbMot ) 
		{
			System.out.print("mot"+indice);
			tab[indice].afficher();
			indice = indice + 1 ;
		}
	}


	public void ajouter( ) 
	{
		Definition def;
	
		def = new Definition( ) ;
		def.saisir( ) ;
		nbMot = nbMot + 1 ;
		tab[nbMot]= def ;
		trier( ) ;
	}


	public int rechercher(String mot) 
	// Explication : recherche itrative.
	{
		int  indice;
		indice = 1 ;
		while ((indice <= nbMot) && !(tab[indice].accederMot().equals(mot))) 
			indice = indice + 1 ;
		
		if ( (indice > 0) && (indice <= nbMot) ) 
			return indice ;
		else
			return (-1) ;
	}



	public int rechercherRapide(String mot) 
	// la mthode de recherche dichotomique !
	{
		int 	gauche, milieu, droite;
 		boolean trouve;


		gauche=1 ;
		droite=nbMot ;
		milieu=(gauche + droite) / 2 ; 			// division entire pour trouver le milieu
		trouve=false;

		while ( (gauche <= droite ) && (!trouve) ) 	// si on ne trouve rien,
 						//  un moment on a gauche  droite
		{
			milieu=(gauche+droite) / 2 ;			// recalcule le milieu (DIV)
			trouve=(tab[milieu].accederMot().equals(mot) ) ;   // on a trouv l'lment ?

			if ( (tab[milieu].accederMot()).compareTo(mot) < 0 ) 
				gauche=milieu + 1 ; 			// l'lment est  droite du milieu
			else					// sinon, il est  gauche du milieu
				droite=milieu - 1 ;
		}
		
		if ( trouve == true) 
			return milieu ;				// on sort, on a trouv !
		else
			return (-1) ; 				// lment introuvable : on sort


	}





/////////////fonctions ncessaires au programme	
private int lire()
	{	String chaine = new String();
		System.out.print("Entrez une valeur :");
		chaine = lireClavier();
		System.out.println();
		return (new Integer(chaine).intValue());
	}
	
private String lireClavier()  {
		byte[] lu=new byte[50];
		try {	System.in.read(lu,0,50); }
		catch (IOException e) {	System.out.print("Erreur dans la saisie"); }
		String s = new String(lu,0,50);
		return s.trim();
	}



}
