/**
 * Algorithme du train
 * 
 * @author Dabancourt C.
 * @version 1.0 08/08/2000
 */

import java.lang.String;

class Train extends Thread
{
	Semaphore rail;
	int debut, fin;
	int entree, sortie;	// pour dfinir les point A et B
	int sens;
	String nom;
		
	Train(int debut, int fin, Semaphore rail, String nom)
	{	this.rail  = rail;
		this.nom   = nom;
		this.debut = debut;
		this.fin   = fin;
		
		if ( debut < fin ){
			entree=5; sortie=10; sens=1;
		} else {
			entree=10; sortie=5; sens=-1;
		}		
	}
	
	public void run() {
		nom();System.out.println("je suis parti !") ;
		int position = debut;
		int prochainePosition;
		
		while (position != fin){
			nom();System.out.println("ma position :"+position) ;
			
			prochainePosition = position + sens;
			
			if (prochainePosition==entree){
				while (rail.occupe()==true){
					attendre(300);
					nom();System.out.println("j'attend la liberation !") ;
				}	
				nom();System.out.println("j'occupe la voie !") ;
				rail.initialise();
			}
			
			if (prochainePosition==sortie){
				rail.signaler();
				nom();System.out.println("je quitte la voie !") ;
			}
			position = prochainePosition ;
			
			attendre(500);
		}
		System.out.println("le train "+nom+" est arrive") ;
  	}
	
	
	private void attendre(int duree){
		try {this.sleep(duree);}	// le thread s'arrete 0.5 seconde
			catch (InterruptedException e) {}
	}

	private void nom(){
		System.out.print(nom+":") ;
	}	
}



class Test
{
	public static void main (String[] argv)
	{
		Semaphore rail = new Semaphore(1);
		Train trainA = new Train(3,11, rail,"trainA");		
		Train trainB = new Train(16,1, rail,"trainB");
		System.out.println("les trains sont lancs !") ;
		trainA.start();
		trainB.start();
      	}
}