/**
 * Classe Explosion
 * Une Explosion doit faire exploser toutes les mines si une seule explose.
 *
 * @author Dabancourt C.
 * @version 1.0 08/08/2000
 */
 

import java.util.Vector; //une liste

class Explosion {
	Vector listeMines;
	Terrain terrain;
	int etat;// 0:pas encore explos - 1:explose
	
	Explosion(Terrain terrain){
		this.terrain = terrain;
		listeMines = new Vector();
		etat=0;
	}
	
	
	public void add(CaseMine mine){
		listeMines.add(mine);
	}
	
	public void exploser() { 
		CaseMine c;
		etat=1;
		for (int i = 0; i < listeMines.size(); i++){
			c = (CaseMine)listeMines.elementAt(i);
			c.decouvre();
			c.afficher(terrain.getGraphics(),terrain);
		}
		terrain.perdu();
	}
	public int getEtat(){
		return etat;
	}
	
}
