#include "chaine.h"
#include <iostream.h>
#include <string.h>
#include <assert.h>
#include <stdlib.h>      
//**********************************************************************
// Definition des fonctions de Chaine***********************************

void Chaine::init(const char *s){
        _libere();
        _init(s);
}

void Chaine::init (const Chaine & ch){
        _libere();
        _init(ch.ptr);
}

void Chaine::init (int n, char c){
        _libere();
        _init(n,c);
}

int Chaine::longueur() const
    {return lg;}

char Chaine::iemeCar(int i) const {
        assert((i>=0) && (i<lg));
        return ptr[i];
}

void Chaine::ecrire() const {cout<<ptr;}

Bool Chaine::estEgaleA(const Chaine & ch) const {
        int r=strcmp(ptr,ch.ptr);
        return (!r);
}

Bool Chaine::precede(const Chaine & ch) const {
        int r=strcmp(ptr,ch.ptr);
        return(r<0);
}

void Chaine::lire(){
        _libere();
        char tampon[256];
        cin>>tampon;
        _init(tampon);
}

void Chaine::copier(const Chaine & ch ){
        if (&ch!=this){
                _libere();
                _init(ch.ptr);
        }
}

void Chaine::extraire(const Chaine & ch, int deb, int fin){
        assert((deb>=0) && (deb<=fin) && (fin <ch.lg));
        _libere();
        lg=fin-deb+1;
        _reserve(lg+1);
        strncpy(ptr,ch.ptr+deb,lg);
        ptr[lg]='\0';
}

void Chaine::modifierIeme(int i, char c){
        assert(i>=0 && i<lg);
        ptr[i]=c;
}

void Chaine::concatene(const Chaine & ch){
        lg+=ch.lg;
        char * old = ptr;
        _reserve(lg+1);
        strcpy(ptr,old);
        strcat(ptr,ch.ptr);
        delete [] old;
}

// Constructeurs
Chaine::Chaine (const char * s)
        {_init(s);}

Chaine::Chaine (const Chaine & ch)
        {_init(ch.ptr);}

Chaine::Chaine (int n, char c)
        {_init(n,c);}

Chaine::~Chaine(){_libere();}

// Methodes prives
void Chaine::_reserve(int n){
        ptr=new char[n];
        assert(ptr!=NULL);
}

void Chaine::_libere(){ delete[]ptr;}


void Chaine::_init(const char *  ch){
        lg=strlen(ch);
        _reserve(lg+1);
        strcpy(ptr,ch);
}

void Chaine::_init (int n, char c){
        lg=n;
        _reserve(lg+1);
        for(int i=0;i<lg;i++)
                ptr[i]=c;
        ptr[lg]='\0';
}

//******************************************
// FONCTIONS SUR CHAINES ET NOMBRES
float Chaine::convertis()
        {return atof(PtrStr());}

Bool Chaine::estNombre(){
        char * test;
        strtod (PtrStr(), &test);
        return(*test='\0');
}



