// CLASSE CHAINE  - ALGO  *********************************************

/** 
 * Algorithme : la classe Chaine 
 * 
 * La classe Chaine possde de nombreuses mthodes : 
 * init ( ) retourne vide 
 * init (Chaine) retourne vide 
 * init (suite de Caractres) retourne vide 
 * ecrire ( ) retourne vide  
 * lire ( ) retourne vide 
 * longueur ( ) retourne Entier  
 * estEgaleA( ) retourne Boolen  
 * precede ( ) retourne Boolen 
 * iemeCar( ) retourne Caractre  
 * modifierIeme (Entier, Chaine) retourne vide 
 * concatene (Chaine) retourne Boolen 
 * extraire (Chaine, Entier, Entier) retourne vide 
 * copier (Chaine) retourne vide 
 * 
 */ 


/* ******Dans chaine.h :***************************************************
Deux fonctions ajoutees :
	ch.estNombre() retourne VRAI si ch represente un nombre entier ou reel
	ch.convertis() retourne la valeur numerique (reelle) de ch
*/

#ifndef _CHAINE_H
#define _CHAINE_H
#ifndef _BOOL_H
	#define _BOOL_H
	typedef int Bool;
	const int VRAI=1,FAUX=0;
#endif

//**********************Declaration classe Chaine****************************
class Chaine{

public:
// Initialisateurs :
	void init(const char * ="");
	void init (const Chaine &);
	void init (int, char);
// Observateurs :
	void ecrire() const ;
	int longueur() const;	// nb de caracteres de la chaine
	Bool estEgaleA(const  Chaine &)const  ;
	Bool precede(const Chaine &)const ;
	char iemeCar(int i) const ;	//caractere a la position i

// Modificateurs :
	void lire();
	void copier(const Chaine & );
	void modifierIeme(int, char);
	void concatene(const Chaine & );
	void extraire(const Chaine & , int , int );

// Constructeurs
	Chaine (const char * ="");
	Chaine (const Chaine & ch);
	Chaine (int n, char c);
// Destructeur
	~Chaine();


protected:
	char * ptr;	// pointeur vers le tableau contenant les caractres
	int lg;		// nombre de caractres (non compris '\0')

// Fonctions utilitaires
	void _reserve(int n);
	void _libere();
	void _init(const char *);
	void _init (int n, char c);
public :
	char * PtrStr(){return ptr;}
	float convertis();
	Bool estNombre();

};
#endif
