/**
 * Algorithme : la classe Chaine
 *
 * La classe Chaine possde de nombreuses mthodes :
 * init ( ) retourne vide
 * init (Chaine) retourne vide
 * init (suite de Caractres) retourne vide
 * ecrire ( ) retourne vide 
 * lire ( ) retourne vide
 * longueur ( ) retourne Entier 
 * estEgaleA( ) retourne Boolen 
 * precede ( ) retourne Boolen
 * iemeCar( ) retourne Caractre 
 * modifierIeme (Entier, Chaine) retourne vide
 * concatene (Chaine) retourne Boolen
 * extraire (Chaine, Entier, Entier) retourne vide
 * copier (Chaine) retourne vide
 *
 * @author Dabancourt C.
 * @version 1.0 08/08/2000
 */
   
import java.lang.String;	// utilisation d'une bibliothque pour les chaine de caractres : la Classe String
import java.io.*;		// pour les Entres Sorties


class Chaine
{
	private String chaine;
	
	Chaine () {
		chaine = new String();
	}
	
	
	public void init() {
		chaine = new String();
	}
	
	public void  init (String s) 		{ chaine = s;}	
	public void  init (Chaine c) 		{ chaine = c.getString();}
	public void  init (char c []) 		{ String temp=new String(c); chaine = temp;}
	public void  init (char c ) 		{ char ct[]=new char[1]; ct[0]=c; init(ct);}
	public String getString () 		{ return chaine;}
	public void  ecrire ( ) 		{ System.out.println(chaine);}
	public int   longueur ( ) 		{ return chaine.length(); }

	public boolean  estEgaleA(Chaine c ) 	{ 
		if (chaine.compareTo(c.getString())==0) return true;
		else return false; 
		 };

	public boolean  precede (Chaine c ) 	{ 
		if (chaine.compareTo(c.getString())<0) return true;
		else return false; 
	}
		
	public char  iemeCar(int i ) 		{ char c [] = chaine.toCharArray(); return c[i-1];}

	public void  modifierIeme (int i, char caractere) { 
		char c [] = chaine.toCharArray(); 
		c[i-1]=caractere;
		init (c);
	}

	public void  concatene (Chaine c) 	{chaine=chaine +c.getString(); 	}
	
	public void  extraire (Chaine c, int debut, int fin) { chaine = c.getString().substring(debut-1,fin);}

	public void  copier (Chaine c) 		{ chaine = c.getString();}
	
	
	
	public void lire()
	{	System.out.print("Entrez une chaine :");
		chaine = lireClavier();
		System.out.println();
	}	
	
	
	private String lireClavier()  {

		byte[] lu=new byte[50];
		try {	System.in.read(lu,0,50); }
		catch (IOException e) {	System.out.print("Erreur dans la saisie"); }
		String s = new String(lu,0,50);
		return s.trim();
	}	


	/** la mthode chaine2Entier( )  est publique et retourne le nombre entier
	  * correspondant  la chaine de caractres.
	  *
	  */

	public int chaine2Entier()
	{
		int valeur, pos, chiffre, chiffreAscii, puissance;

		valeur = 0 ;
		puissance = 1 ;				// pour les multiple de 10

		pos  = longueur () ;
		while ( pos >= 1 )
		{
			if ( iemeCar(pos) == '-' ) 
				valeur = - valeur ;
			else
				if ( iemeCar(pos) == '+' )
					valeur = valeur ;
				else 
				{
				chiffreAscii = (int) iemeCar(pos) ;	// conversion ascii
				chiffre = chiffreAscii - 48 ;		// 8 - 48 = 8
				valeur = valeur + puissance * chiffre ;	// 57 + 100 * 8
				puissance = puissance * 10 ;		// puissance = 1, 10, 100, 1000
				}
			pos = pos - 1;
		}
		return ( valeur) ;
	}


	public void init ( int n){
		chaine=new String().valueOf(n); // utilisons la mthode de Java 
	}

	
	public int posSousChaine(Chaine sc) 
	{
	int pos, longueur, scLongueur;
	Chaine ch;

		ch = new Chaine();
		pos = 1 ;
		longueur = longueur() ;
		scLongueur = sc.longueur( ) ;

		ch = new Chaine();

		while (  pos <= longueur-scLongueur+1 ) 
		{
			ch.extraire ( this, pos, pos + scLongueur - 1) ;
			// ch.ecrire();				//  dcommenter pour voir la trace de l'excution
			if ( sc.estEgaleA(ch) ) 
				return pos ;
			else
				pos = pos + 1 ;
		}
		return -1 ;					// pas trouve
	}

	
	
	
/** quand on programme, il y a 3 tapes
 *	1) on utilise un papier et un crayon pour ECRIRE l'exemple de LA mthode et  son algorithme
 *	2) on programme une mthode.
 *	3) on la teste immdiatement (avant de passer  une autre !!)
 *
 *	on DOIT TOUJOURS pouvoir montrer l'tat du programme en excutant ce qui a t fais
 *	(en mettant en commentaire les quelques dernires lignes en cours d'criture)
 *
 *	A NE PAS FAIRE : tout crire au dbut sans rien tester... pour tout corriger  la fin.
 */
	public static void main (String[] argv)
	{
		Chaine c = new Chaine ();
		c.init("ordinateur");
		c.lire();
		c.ecrire();
		Chaine d = new Chaine ();

		d.extraire ( c, 3 , 6) ;
		d.ecrire();
		
		c.concatene(d);
		c.ecrire();
		System.out.println(c.iemeCar(3));
		d.lire();
		int i=d.chaine2Entier();
		System.out.println("i="+i);
		
		d.init (-55);
		d.ecrire();
		
		d.init("gaston lagaffe");
		c.init("ga");	System.out.println("position : " + d.posSousChaine(c) );
		c.init("gaf");	System.out.println("position : " + d.posSousChaine(c) );
		c.init("toto");	System.out.println("position : " + d.posSousChaine(c) );
	}      	
}
