/**
 * Classe Hierarchie
 * la classe Hierarchie est un graphique (ou Canvas) particulier : elle hrite de la classe Canvas.
 * la classe TestHierarchie a t faite pour tester la classe Hierarchie dans une fentre.
 *
 *
 * @author Dabancourt C.
 * @version 1.0 08/08/2000
 */
  
import java.awt.*;	// utilisation de la bibliothque graphique



class TestHierarchie
{
	public static void main (String[] argv)
	{
    		Frame fenetre = new Frame();

    		fenetre.setTitle("emission");
		fenetre.setLocation(100,200);
		fenetre.setSize(500,500);

		
		Point pt=new Point(200,200);
    		Hierarchie hierarchie = new Hierarchie(pt, 100, 6);	// A=pt, h=100 pixels, n=6
    		fenetre.add(hierarchie);
		fenetre.setVisible(true);				// appel implicite de la mthode paint()
		
      	}
}


class Hierarchie extends Canvas {

	Point ptstart;
	int hstart; 
	int nstart;

	// il faut un constructeur !
	Hierarchie(Point debut, int h, int n) 
	{
		ptstart=debut;
		hstart=h;
		nstart=n;
	}


	// Canvas possde la mthode paint qui permet de faire le dessin
	public void paint(Graphics feuille) { 
		dessineHierarchie(ptstart, hstart, nstart);
	}

	
	
	public void dessineHierarchie(Point A, int h, int n) //appel par la mthode paint()
	{
		if ( n == 0 ) 
			return;
		else 
		{
			Point B = new Point ( A.x - h , A.y - h ) ;
			Point C = new Point ( A.x + h , A.y - h ) ;
			Point H = new Point ( A.x     , A.y - h ) ;

			getGraphics( ).drawLine (B.x, B.y, C.x, C.y) ;	// dessine BC
			getGraphics( ).drawLine (A.x, A.y, H.x, H.y) ;	// dessine AH
	
			dessineHierarchie( B,  h/2, n-1 ) ;		// appel rcursif
			dessineHierarchie( C,  h/2, n-1 ) ;		// appel rcursif
		}
	}
	
 	
	
	
}


