/**
 * Classe ListeChainee
 * Une ListeChainee est constue de CelluleEntier.
 *
 *
 * @author Dabancourt C.
 * @version 1.0 08/08/2000
 */


class TestListe
{	
	public static void main (String[] argv)
	{
		ListeChainee lst = new ListeChainee();
		lst.ajouterTete(6);
		lst.ajouterTete(7);
		lst.afficher();
		lst.ajouterQueue(5);
		lst.afficher();
		lst.retirerTete();
		lst.afficher();
		lst.retirerQueue();
		lst.afficher();
		
	}
	
}



class ListeChainee
{


	private CelluleEntier tete;
	private CelluleEntier courant;
	int longueur;


	ListeChainee ( ) 
	{
		tete = null ;
		courant=null;
	}

/////////////////////////////////
// on ajoute la mthode de construction par recopie 
	ListeChainee(ListeChainee lst) {
		
		lst.razCourant() ;

		while ( lst.enFinCourant() != true  ) 
		{
			ajouterTete( lst.getCourant() );
			lst.nextCourant() ;
		}
		razCourant();
	}
/////////////////////////////////
	

	public boolean estVide ( ) 
	{
	if (tete == null)
		return true;
	else
		return false ;
	}



	public void ajouterTete (int e )
	{
		CelluleEntier nouv_cel;
	
		nouv_cel = new CelluleEntier(e, tete) ;   // la nouvelle cellule pointe comme tte, et contient llment e.
		tete = nouv_cel ;
	}


	public void ajouterQueue (int e) 
	{
                CelluleEntier ptr, nouvCel;

		ptr = tete ;
		while ( ptr.accesSuivant ( ) != null ) 
		{
			ptr = ptr.accesSuivant ( ) ;
		}
		nouvCel = new CelluleEntier (e, null ) ;
		ptr.modifier( nouvCel) ;
	}


	public void retirerTete ( ) 
	{
		tete = tete.accesSuivant ( ) ;
	}


	public void retirerQueue ( ) 
	{
		CelluleEntier ptr;
		ptr = tete ;
		while ( ptr.accesSuivant().accesSuivant() != null) 
		{
			ptr = ptr.accesSuivant();
		}
		ptr.modifier(null) ;
	}
	
	
	public void afficher ( ) 
	{
		CelluleEntier ptr = tete ;
		while ( ptr != null) 
		{
			System.out.println(ptr.accesElement());
			ptr = ptr.accesSuivant();
		}
		System.out.println("***");
	}
	
	
/////////////////////////////////
// on ajoute quelques mthodes (gestion du courant)


	public int getCourant() {
		return courant.accesElement();
	}


	public boolean enFinCourant() {	// permet de savoir si courant est arriv au bout de la liste !
		if (courant ==null)	// on aurait pu imaginer  la place que 
					// la mthode nextCourant retourne un boolen.
			return true;
		else
			return false;
	}

	public void razCourant() {
		courant=tete;
	}

	public void nextCourant() {
		courant=courant.accesSuivant();
	}


	public int size(){
		
		int indice;
		CelluleEntier c;
		
		indice = 0;
		c=courant;	// sauvegarde
		
		razCourant();
		while(enFinCourant() != true)
		{
			nextCourant();
			indice =indice + 1;
		}
			
		courant = c;	// on remet la sauvegarde
		return indice;
		
	}



}

