/**
 * Classe Terrain
 *
 * La classe qui contient les Cases.
 * Terrain drive de Canvas : le Terrain est un graphique inclus dans une Frame (dem1)
 * 
 *
 * @author Dabancourt C.
 * @version 1.0 08/08/2000
 */


import java.awt.*;
import java.awt.event.*;
import java.util.Vector; //une liste

class Terrain extends Canvas {

	public Case t[][];
	private int	  largeur,hauteur; 
	private int	  tailleCase;	 // taille d'une case en pixel

	static final int Bombe=10,Mystere=9;
	static final int Zero=0, Un=1, Deux=2, Trois=3, Quatre=4, Cinq=5, Six=6, Sept=7, Huit=8;

	private Graphics feuille;
	GestionSouris gestSouris;
	Explosion explosion;
 
 
	Terrain(int l, int h, int tc)   {
		

		// les attributs
		largeur = l;//10;
		hauteur = h;//13;
		tailleCase = 16;//tc=16 pixels;
		
		feuille = getGraphics();
		setSize(largeur*tailleCase, hauteur*tailleCase);	
		
		explosion = new Explosion(this);
		
	// calcul du champ de mine
		Hasard hasard = new Hasard(largeur, hauteur);
	// initialisation du terrain
		t = new Case [largeur][hauteur];
		int nbMine;
		for (int x = 0; x <largeur; x++) {
			for (int y = 0; y < hauteur ; y++) {
				nbMine = hasard.getHasardResultat(x,y);
				if (nbMine==10){
					System.out.println("mine");
					CaseMine c = new CaseMine( x, y, nbMine);
					t[x][y]=c;
					c.setExplosion(explosion);
					explosion.add(c);
				} else {
					t[x][y] = new Case( x, y, nbMine);
				}
			}
		}
	// nouvel couteur : gestSouris
		gestSouris = new GestionSouris(this);
		addMouseListener(gestSouris);
	}


	public void paint(Graphics feuille) { 
		feuille=getGraphics();
		for (int x = 0; x < largeur; x++)
			for (int y = 0; y < hauteur ; y++)
				t[x][y].afficher(feuille,this);
	}

	public void getCase(int x, int y) { 
		t[x/16][y/16].cliqueGauche();
		t[x/16][y/16].afficher(getGraphics(),this);
	}


	public void perdu() { 
		removeMouseListener(gestSouris);
	}
}